/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.ajax.writer.DataWriter;
import com.openexchange.ajax.writer.FolderChildWriter;
import com.openexchange.ajax.writer.WriterProcedure;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.session.Session;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.json.JSONWriter;

public class CommonWriter
extends FolderChildWriter {
    private static final DataWriter.FieldWriter<CommonObject> CATEGORIES_WRITER = new DataWriter.FieldWriter<CommonObject>(){

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getCategories(), json, obj.containsCategories());
        }

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("categories", obj.getCategories(), json, obj.containsCategories());
        }
    };
    private static final DataWriter.FieldWriter<CommonObject> PRIVATE_FLAG_WRITER = new DataWriter.FieldWriter<CommonObject>(){

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getPrivateFlag(), json, obj.containsPrivateFlag());
        }

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("private_flag", obj.getPrivateFlag(), json, obj.containsPrivateFlag());
        }
    };
    private static final DataWriter.FieldWriter<CommonObject> COLORLABEL_WRITER = new DataWriter.FieldWriter<CommonObject>(){

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getLabel(), json, obj.containsLabel());
        }

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("color_label", obj.getLabel(), json, obj.containsLabel());
        }
    };
    private static final DataWriter.FieldWriter<CommonObject> NUMBER_OF_ATTACHMENTS_WRITER = new DataWriter.FieldWriter<CommonObject>(){

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getNumberOfAttachments(), json, obj.containsNumberOfAttachments());
        }

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("number_of_attachments", obj.getNumberOfAttachments(), json, obj.containsNumberOfAttachments());
        }
    };
    private static final DataWriter.FieldWriter<CommonObject> LAST_MODIFIED_OF_NEWEST_ATTACHMENT_UTC_WRITER = new DataWriter.FieldWriter<CommonObject>(){

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getLastModifiedOfNewestAttachment(), DataWriter.UTC, json, obj.containsLastModifiedOfNewestAttachment());
        }

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("lastModifiedOfNewestAttachmentUTC", obj.getLastModifiedOfNewestAttachment(), DataWriter.UTC, json, obj.containsLastModifiedOfNewestAttachment());
        }
    };
    private static final DataWriter.FieldWriter<CommonObject> NUMBER_OF_LINKS_WRITER = new DataWriter.FieldWriter<CommonObject>(){

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getNumberOfLinks(), json, obj.containsNumberOfLinks());
        }

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONObject json, Session session) {
        }
    };
    private static final DataWriter.FieldWriter<CommonObject> EXTENDED_PROPERTIES_WRITER = new DataWriter.FieldWriter<CommonObject>(){

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONArray json, Session session) throws JSONException {
            Map<String, Object> extendedProperties = obj.getExtendedProperties();
            DataWriter.writeValue(null == extendedProperties ? null : (JSONValue)JSONCoercion.coerceToJSON(extendedProperties), json, obj.containsExtendedProperties());
        }

        @Override
        public void write(CommonObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            Map<String, Object> extendedProperties = obj.getExtendedProperties();
            DataWriter.writeParameter("extended_properties", null == extendedProperties ? null : (JSONValue)JSONCoercion.coerceToJSON(extendedProperties), json, obj.containsExtendedProperties());
        }
    };
    private static final TIntObjectMap<DataWriter.FieldWriter<CommonObject>> WRITER_MAP;

    protected CommonWriter(TimeZone tz, JSONWriter jsonwriter) {
        super(tz, jsonwriter);
    }

    public void writeCommonFields(CommonObject commonObj, JSONObject jsonObj, Session session) throws JSONException {
        this.writeFields(commonObj, this.timeZone, jsonObj, session);
    }

    protected boolean writeField(CommonObject obj, int column, TimeZone tz, JSONArray json, Session session) throws JSONException {
        DataWriter.FieldWriter writer = (DataWriter.FieldWriter)WRITER_MAP.get(column);
        if (null == writer) {
            return super.writeField(obj, column, tz, json, session);
        }
        writer.write(obj, this.timeZone, json, session);
        return true;
    }

    protected void writeFields(CommonObject obj, TimeZone tz, JSONObject json, Session session) throws JSONException {
        JSONException je;
        super.writeFields(obj, tz, json, session);
        WriterProcedure<CommonObject> procedure = new WriterProcedure<CommonObject>(obj, json, tz, session);
        if (!WRITER_MAP.forEachValue(procedure) && null != (je = procedure.getError())) {
            throw je;
        }
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap(6, 1.0f);
        m.put(100, CATEGORIES_WRITER);
        m.put(101, PRIVATE_FLAG_WRITER);
        m.put(102, COLORLABEL_WRITER);
        m.put(104, NUMBER_OF_ATTACHMENTS_WRITER);
        m.put(105, LAST_MODIFIED_OF_NEWEST_ATTACHMENT_UTC_WRITER);
        m.put(103, NUMBER_OF_LINKS_WRITER);
        m.put(107, EXTENDED_PROPERTIES_WRITER);
        WRITER_MAP = m;
    }
}

