/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.exception.OXException;
import com.openexchange.preview.PreviewDocument;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewResponseRenderer
implements ResponseRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewResponseRenderer.class);

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return result.getResultObject() instanceof PreviewDocument;
    }

    @Override
    public int getRanking() {
        return 0;
    }

    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest httpReq, HttpServletResponse httpResp) {
        try {
            PreviewDocument previewDocument = (PreviewDocument)result.getResultObject();
            JSONArray jsonArray = new JSONArray();
            for (String previewPage : previewDocument.getContent()) {
                jsonArray.put((Object)previewPage);
            }
            JSONObject jsonObject = new JSONObject();
            if (previewDocument.isMoreAvailable() != null) {
                jsonObject.put("moreAvailable", (Object)previewDocument.isMoreAvailable());
            }
            jsonObject.put("document", (Object)jsonArray);
            Response response = new Response(request.getSession());
            response.setTimestamp(result.getTimestamp());
            response.setData(jsonObject);
            response.setProperties(result.getResponseProperties());
            Collection<OXException> warnings = result.getWarnings();
            if (warnings != null && !warnings.isEmpty()) {
                for (OXException warning : warnings) {
                    response.addWarning(warning);
                }
            }
            APIResponseRenderer.writeResponse(response, request.getAction(), httpReq, httpResp);
        }
        catch (JSONException e) {
            LOG.error("JSON Error", (Throwable)e);
        }
    }
}

