/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache.osgi;

import com.openexchange.ajax.requesthandler.cache.AbstractResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCaches;
import com.openexchange.ajax.requesthandler.converters.preview.cache.FileStoreResourceCacheImpl;
import com.openexchange.ajax.requesthandler.converters.preview.cache.RdbResourceCacheImpl;
import com.openexchange.ajax.requesthandler.converters.preview.cache.ResourceCacheMBean;
import com.openexchange.ajax.requesthandler.converters.preview.cache.ResourceCacheMBeanImpl;
import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.AddRefIdForPreviewCacheTable;
import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.DropDataFromPreviewCacheTable;
import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.PreviewCacheCreateDataTableService;
import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.PreviewCacheCreateDataTableTask;
import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.PreviewCacheCreateTableService;
import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.PreviewCacheCreateTableTask;
import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.PreviewCacheDeleteListener;
import com.openexchange.config.ConfigurationService;
import com.openexchange.database.CreateTableService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.groupware.update.DefaultUpdateTaskProviderService;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.management.ManagementService;
import com.openexchange.osgi.HousekeepingActivator;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceCacheActivator
extends HousekeepingActivator {
    private volatile ObjectName objectName;

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class};
    }

    protected void startBundle() throws Exception {
        AbstractResourceCache eventHandler;
        AbstractResourceCache cache;
        final class ServiceTrackerCustomizerImpl
        implements ServiceTrackerCustomizer<ManagementService, ManagementService> {
            private final BundleContext bundleContext;

            public ServiceTrackerCustomizerImpl(BundleContext bundleContext) {
                this.bundleContext = bundleContext;
            }

            public ManagementService addingService(ServiceReference<ManagementService> reference) {
                ManagementService management = (ManagementService)this.bundleContext.getService(reference);
                ResourceCacheActivator.this.registerCacheMBean(management);
                return management;
            }

            public void modifiedService(ServiceReference<ManagementService> reference, ManagementService service) {
            }

            public void removedService(ServiceReference<ManagementService> reference, ManagementService service) {
                ManagementService management = service;
                ResourceCacheActivator.this.unregisterCacheMBean(management);
                this.bundleContext.ungetService(reference);
            }
        }
        this.track(ManagementService.class, new ServiceTrackerCustomizerImpl(this.context));
        this.openTrackers();
        ConfigurationService configurationService = (ConfigurationService)this.getService(ConfigurationService.class);
        String type = configurationService.getProperty("com.openexchange.preview.cache.type", "FS").trim();
        if ("DB".equalsIgnoreCase(type)) {
            RdbResourceCacheImpl rdbPreviewCacheImpl;
            cache = rdbPreviewCacheImpl = new RdbResourceCacheImpl();
            eventHandler = rdbPreviewCacheImpl;
        } else {
            boolean quotaAware = configurationService.getBoolProperty("com.openexchange.preview.cache.quotaAware", false);
            FileStoreResourceCacheImpl fileStorePreviewCache = new FileStoreResourceCacheImpl(quotaAware);
            cache = fileStorePreviewCache;
            eventHandler = fileStorePreviewCache;
        }
        ResourceCacheMBeanImpl.CACHE_REF.set(cache);
        this.registerService(ResourceCache.class, cache);
        Hashtable<String, String[]> d = new Hashtable<String, String[]>(1);
        ((Dictionary)d).put("event.topics", new String[]{"com/openexchange/groupware/infostore/update", "com/openexchange/groupware/infostore/delete"});
        this.registerService(EventHandler.class, eventHandler, d);
        ResourceCaches.setResourceCache(cache);
        this.registerService(CreateTableService.class, (Object)new PreviewCacheCreateTableService());
        this.registerService(CreateTableService.class, (Object)new PreviewCacheCreateDataTableService());
        this.registerService(UpdateTaskProviderService.class, new DefaultUpdateTaskProviderService(new PreviewCacheCreateTableTask(), new AddRefIdForPreviewCacheTable(), new PreviewCacheCreateDataTableTask(), new DropDataFromPreviewCacheTable()));
        this.registerService(DeleteListener.class, new PreviewCacheDeleteListener());
    }

    protected void stopBundle() throws Exception {
        ResourceCaches.setResourceCache(null);
        super.stopBundle();
    }

    void registerCacheMBean(ManagementService management) {
        ObjectName objectName = this.objectName;
        if (objectName == null) {
            try {
                this.objectName = objectName = ResourceCacheActivator.getObjectName(ResourceCacheMBean.class.getName(), "com.openexchange.preview.cache");
                management.registerMBean(objectName, (Object)new ResourceCacheMBeanImpl());
            }
            catch (MalformedObjectNameException e) {
                Logger LOG = LoggerFactory.getLogger(ResourceCacheActivator.class);
                LOG.error("", (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                Logger LOG = LoggerFactory.getLogger(ResourceCacheActivator.class);
                LOG.error("", (Throwable)e);
            }
            catch (OXException e) {
                Logger LOG = LoggerFactory.getLogger(ResourceCacheActivator.class);
                LOG.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterCacheMBean(ManagementService management) {
        ObjectName objectName = this.objectName;
        if (objectName != null) {
            try {
                management.unregisterMBean(objectName);
            }
            catch (OXException e) {
                Logger LOG = LoggerFactory.getLogger(ResourceCacheActivator.class);
                LOG.error("", (Throwable)e);
            }
            finally {
                this.objectName = null;
            }
        }
    }

    private static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}

