/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache.console;

import com.openexchange.ajax.requesthandler.converters.preview.cache.ResourceCacheMBean;
import com.openexchange.management.console.JMXAuthenticatorImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class PreviewCacheTool2 {
    private static final Options sOptions = new Options();

    private PreviewCacheTool2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        boolean error = true;
        try {
            HashMap<String, JMXAuthenticatorImpl> environment;
            String val;
            String contextOptionVal;
            CommandLine cmd = parser.parse(sOptions, args);
            if (cmd.hasOption('h')) {
                PreviewCacheTool2.printHelp();
                System.exit(0);
                return;
            }
            if (cmd.hasOption('a')) {
                contextOptionVal = null;
            } else {
                if (!cmd.hasOption('c')) {
                    System.out.println("Either parameter 'context' or parameter 'all' is required.");
                    PreviewCacheTool2.printHelp();
                    System.exit(1);
                    return;
                }
                contextOptionVal = cmd.getOptionValue('c');
            }
            String invalids = null;
            if (cmd.hasOption('i')) {
                invalids = cmd.getOptionValue('i');
                if ((invalids = invalids.trim()).startsWith("\"") && invalids.endsWith("\"")) {
                    invalids = invalids.substring(1, invalids.length() - 1);
                    invalids = invalids.trim();
                }
            }
            int port = 9999;
            if (cmd.hasOption('p') && null != (val = cmd.getOptionValue('p'))) {
                try {
                    port = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Port parameter is not a number: " + val);
                    PreviewCacheTool2.printHelp();
                    System.exit(1);
                }
                if (port < 1 || port > 65535) {
                    System.err.println("Port parameter is out of range: " + val + ". Valid range is from 1 to 65535.");
                    PreviewCacheTool2.printHelp();
                    System.exit(1);
                }
            }
            String jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            String jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, JMXAuthenticatorImpl>(1);
                environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, environment);
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                try {
                    ResourceCacheMBean previceCacheProxy = PreviewCacheTool2.previewCacheMBean(mbsc);
                    String resultDesc = previceCacheProxy.sanitizeMimeTypesInDatabaseFor(null == contextOptionVal ? -1 : Integer.parseInt(contextOptionVal.trim()), invalids);
                    System.out.println(resultDesc);
                }
                catch (Exception e) {
                    String errMsg = e.getMessage();
                    System.out.println(errMsg == null ? "An error occurred." : errMsg);
                }
            }
            finally {
                try {
                    jmxConnector.close();
                }
                catch (Exception e) {}
            }
            error = false;
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            PreviewCacheTool2.printHelp();
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        finally {
            if (error) {
                System.exit(1);
            }
        }
    }

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(74, "sanitizefilemimetypes", null, sOptions, "The options -c/--context and -a/--all are mutually exclusive.", false);
    }

    private static ResourceCacheMBean previewCacheMBean(MBeanServerConnection mbsc) throws MalformedObjectNameException {
        return MBeanServerInvocationHandler.newProxyInstance(mbsc, PreviewCacheTool2.getObjectName(ResourceCacheMBean.class.getName(), "com.openexchange.preview.cache"), ResourceCacheMBean.class, false);
    }

    private static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }

    static {
        sOptions.addOption("h", "help", false, "Prints a help text");
        sOptions.addOption("c", "context", true, "Required. The context identifier");
        sOptions.addOption("a", "all", false, "Required. The flag to signal that contexts shall be processed. Hence option -c/--context is then obsolete.");
        sOptions.addOption("i", "invalids", true, "An optional comma-separated list of those MIME types that should be considered as broken/corrupt. Default is \"application/force-download, application/x-download, application/$suffix\"");
        sOptions.addOption("p", "port", true, "The optional JMX port (default:9999)");
        sOptions.addOption("l", "login", true, "The optional JMX login (if JMX has authentication enabled)");
        sOptions.addOption("s", "password", true, "The optional JMX password (if JMX has authentication enabled)");
    }
}

