/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.cover;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.converters.cover.CoverExtractor;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4TagCoverField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Mp3CoverExtractor
implements CoverExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(Mp3CoverExtractor.class);
    private static final Set<String> EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".mp3", ".m4a", ".flac", ".wma", ".ogg")));
    private static final Set<String> MP3_MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("audio/mpeg", "audio/x-mpeg", "audio/mp3", "audio/x-mp3", "audio/mpeg3", "audio/x-mpeg3", "audio/mpg", "audio/x-mpg", "audio/x-mpegaudio")));
    private static final Set<String> MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("audio/mpeg", "audio/x-mpeg", "audio/mp3", "audio/x-mp3", "audio/mpeg3", "audio/x-mpeg3", "audio/mpg", "audio/x-mpg", "audio/x-mpegaudio", "audio/mp4", "audio/mp4a-latm", "audio/aac", "audio/aacp", "audio/x-flac", "audio/flac", "audio/x-ms-wma", "application/x-ogg")));

    @Override
    public boolean handlesFile(IFileHolder file) {
        String fileMIMEType = file.getContentType();
        if (null != fileMIMEType && Mp3CoverExtractor.isSupported(fileMIMEType.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        return Mp3CoverExtractor.isSupportedFileExt(file.getName());
    }

    @Override
    public IFileHolder extractCover(IFileHolder file) throws OXException {
        int pos;
        ManagedFileManagement fileManagement = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
        String optExtension = null;
        String name = file.getName();
        if (null != name && (pos = name.indexOf(46)) > 0) {
            optExtension = name.substring(pos);
        }
        ManagedFile managedFile = fileManagement.createManagedFile(file.getStream(), optExtension);
        try {
            File tmpFile = managedFile.getFile();
            if (Mp3CoverExtractor.isMp3(managedFile.getContentType()) || Mp3CoverExtractor.isMp3FileExt(managedFile.getFileName())) {
                MP3File mp3 = new MP3File(tmpFile, 4, true);
                TagField imageField = mp3.getID3v2Tag().getFirstField(FieldKey.COVER_ART);
                if (imageField instanceof AbstractID3v2Frame) {
                    AbstractTagFrameBody body = ((AbstractID3v2Frame)imageField).getBody();
                    if (body instanceof FrameBodyAPIC) {
                        FrameBodyAPIC imageFrameBody = (FrameBodyAPIC)body;
                        if (!imageFrameBody.isImageUrl()) {
                            Object extensions;
                            ByteArrayFileHolder coverFile = new ByteArrayFileHolder((byte[])imageFrameBody.getObjectValue("PictureData"));
                            String mimeType = (String)imageFrameBody.getObjectValue("MIMEType");
                            coverFile.setContentType(mimeType);
                            if (null != mimeType) {
                                extensions = MimeType2ExtMap.getFileExtensions(mimeType);
                                coverFile.setName("cover." + extensions.get(0));
                            }
                            coverFile.setDelivery(file.getDelivery());
                            coverFile.setDisposition(file.getDisposition());
                            extensions = coverFile;
                            return extensions;
                        }
                    } else if (body instanceof FrameBodyPIC) {
                        FrameBodyPIC imageFrameBody = (FrameBodyPIC)body;
                        if (!imageFrameBody.isImageUrl()) {
                            Object extensions;
                            ByteArrayFileHolder coverFile = new ByteArrayFileHolder((byte[])imageFrameBody.getObjectValue("PictureData"));
                            String mimeType = (String)imageFrameBody.getObjectValue("MIMEType");
                            coverFile.setContentType(mimeType);
                            if (null != mimeType) {
                                extensions = MimeType2ExtMap.getFileExtensions(mimeType);
                                coverFile.setName("cover." + extensions.get(0));
                            }
                            coverFile.setDelivery(file.getDelivery());
                            coverFile.setDisposition(file.getDisposition());
                            extensions = coverFile;
                            return extensions;
                        }
                    } else {
                        LOG.warn("Extracting cover image from MP3 failed. Unknown frame body class: {}", (Object)body.getClass().getName());
                    }
                }
            } else if (Mp3CoverExtractor.isSupported(managedFile.getContentType()) || Mp3CoverExtractor.isSupportedFileExt(managedFile.getFileName())) {
                AudioFile f = AudioFileIO.read((File)tmpFile);
                Tag tag = f.getTag();
                if (tag instanceof Mp4Tag) {
                    Mp4Tag mp4tag = (Mp4Tag)tag;
                    List coverarts = mp4tag.get(Mp4FieldKey.ARTWORK);
                    if (null != coverarts && !coverarts.isEmpty()) {
                        Mp4TagCoverField coverArtField = (Mp4TagCoverField)coverarts.get(0);
                        ByteArrayFileHolder coverFile = new ByteArrayFileHolder(coverArtField.getData());
                        String mimeType = Mp4TagCoverField.getMimeTypeForImageType((Mp4FieldType)coverArtField.getFieldType());
                        coverFile.setContentType(mimeType);
                        if (null != mimeType) {
                            List<String> extensions = MimeType2ExtMap.getFileExtensions(mimeType);
                            coverFile.setName("cover." + extensions.get(0));
                        }
                        coverFile.setDelivery(file.getDelivery());
                        coverFile.setDisposition(file.getDisposition());
                        ByteArrayFileHolder byteArrayFileHolder = coverFile;
                        return byteArrayFileHolder;
                    }
                } else {
                    Artwork artwork = tag.getFirstArtwork();
                    if (null != artwork) {
                        ByteArrayFileHolder coverFile = new ByteArrayFileHolder(artwork.getBinaryData());
                        String mimeType = artwork.getMimeType();
                        coverFile.setContentType(mimeType);
                        if (null != mimeType) {
                            List<String> extensions = MimeType2ExtMap.getFileExtensions(mimeType);
                            coverFile.setName("cover." + extensions.get(0));
                        }
                        coverFile.setDelivery(file.getDelivery());
                        coverFile.setDisposition(file.getDisposition());
                        ByteArrayFileHolder byteArrayFileHolder = coverFile;
                        return byteArrayFileHolder;
                    }
                }
            }
            try {
                throw AjaxExceptionCodes.BAD_REQUEST.create();
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
            catch (TagException e) {
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            catch (ReadOnlyFileException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
            catch (CannotReadException e) {
                throw FileStorageExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (InvalidAudioFrameException e) {
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            catch (RuntimeException e) {
                throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (NoClassDefFoundError e) {
                throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        finally {
            managedFile.delete();
        }
    }

    public static boolean isSupportedFileExt(String fileName) {
        if (null != fileName) {
            String lowerCase = fileName.toLowerCase(Locale.ENGLISH);
            for (String extension : EXTENSIONS) {
                if (!lowerCase.endsWith(extension)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMp3FileExt(String fileName) {
        return null != fileName && fileName.toLowerCase(Locale.ENGLISH).endsWith(".mp3");
    }

    public static boolean isMp3(String mimeType) {
        if (null == mimeType) {
            return false;
        }
        return MP3_MIME_TYPES.contains(mimeType);
    }

    public static boolean isSupported(String mimeType) {
        if (null == mimeType) {
            return false;
        }
        return MIME_TYPES.contains(mimeType);
    }
}

