/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONException;

public class NativeConverter
implements ResultConverter {
    @Override
    public String getInputFormat() {
        return "json";
    }

    @Override
    public String getOutputFormat() {
        return "native";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.BAD;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        try {
            result.setResultObject(JSONCoercion.coerceToNative(result.getResultObject()), "native");
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{e.toString(), e});
        }
    }
}

