/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.cache;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCaches {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceCaches.class);
    private static final AtomicReference<ResourceCache> CACHE_REF = new AtomicReference();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ResourceCaches() {
    }

    public static void setResourceCache(ResourceCache ref) {
        CACHE_REF.set(ref);
    }

    public static ResourceCache getResourceCache() {
        return CACHE_REF.get();
    }

    public static String generatePreviewCacheKey(String eTag, AJAXRequestData requestData) {
        StringAllocator sb = new StringAllocator(512);
        sb.append(requestData.getModule());
        sb.append('-').append(requestData.getAction());
        sb.append('-').append(requestData.getSession().getContextId());
        ArrayList<String> parameters = new ArrayList<String>(requestData.getParameters().keySet());
        Collections.sort(parameters);
        for (String name : parameters) {
            if (!ResourceCaches.isAcceptableParameter(name)) continue;
            sb.append('-').append(name);
            String parameter = requestData.getParameter(name);
            if (Strings.isEmpty((String)parameter)) continue;
            sb.append('=').append(parameter);
        }
        try {
            byte[] md5Bytes = sb.toString().getBytes("UTF-8");
            sb.setNewLength(0);
            return sb.append(eTag).append('-').append(ResourceCaches.asHex(MessageDigest.getInstance("MD5").digest(md5Bytes))).toString();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("", (Throwable)e);
        }
        return sb.toString();
    }

    private static boolean isAcceptableParameter(String name) {
        if (Strings.isEmpty((String)name)) {
            return false;
        }
        String n = Strings.toLowerCase((CharSequence)name);
        return !"session".equals(n) && !"action".equals(n);
    }

    public static String asHex(byte[] hash) {
        int length = hash.length;
        char[] buf = new char[length * 2];
        int x = 0;
        for (int i = 0; i < length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }
}

