/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.cache;

import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadata;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadataStore;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.cascade.ComposedConfigProperty;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.sql.Connection;
import java.sql.SQLException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceCache
implements ResourceCache,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResourceCache.class);

    @Override
    public boolean isEnabledFor(int contextId, int userId) throws OXException {
        ConfigViewFactory factory = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
        boolean defaultValue = true;
        if (null == factory) {
            return true;
        }
        ConfigView configView = factory.getView(userId, contextId);
        ComposedConfigProperty enabledProp = configView.property("com.openexchange.preview.cache.enabled", Boolean.TYPE);
        return enabledProp.isDefined() ? (Boolean)enabledProp.get() : true;
    }

    @Override
    public long[] getContextQuota(int contextId) {
        long quota = -1L;
        long quotaPerDocument = -1L;
        ConfigurationService confService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != confService) {
            String property = confService.getProperty("com.openexchange.preview.cache.quota", "10485760").trim();
            try {
                quota = Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                quota = -1L;
            }
            property = confService.getProperty("com.openexchange.preview.cache.quotaPerDocument", "524288").trim();
            try {
                quotaPerDocument = Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                quotaPerDocument = -1L;
            }
        }
        return new long[]{quota, quotaPerDocument};
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if ("com/openexchange/groupware/infostore/update".equals(topic)) {
            try {
                Session session = (Session)event.getProperty("session");
                int userId = session.getUserId();
                int contextId = session.getContextId();
                this.removeAlikes(event.getProperty("eTag").toString(), userId, contextId);
            }
            catch (OXException e) {
                LOG.warn("Couldn't remove cache entry.", (Throwable)e);
            }
        } else if ("com/openexchange/groupware/infostore/delete".equals(topic)) {
            try {
                Session session = (Session)event.getProperty("session");
                int userId = session.getUserId();
                int contextId = session.getContextId();
                this.removeAlikes(event.getProperty("eTag").toString(), userId, contextId);
            }
            catch (OXException e) {
                LOG.warn("Couldn't remove cache entry.", (Throwable)e);
            }
        }
    }

    protected ResourceCacheMetadataStore getMetadataStore() {
        return ResourceCacheMetadataStore.getInstance();
    }

    protected DatabaseService getDBService() throws OXException {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        return dbService;
    }

    protected static ResourceCacheMetadata loadExistingEntry(ResourceCacheMetadataStore metadataStore, Connection con, int contextId, int userId, String id) throws OXException {
        ResourceCacheMetadata existingMetadata = null;
        try {
            existingMetadata = metadataStore.load(con, contextId, userId, id);
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        return existingMetadata;
    }
}

