/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.Attachment;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.parser.AttachmentParser;
import com.openexchange.ajax.request.CommonRequest;
import com.openexchange.ajax.request.SimpleRequest;
import com.openexchange.ajax.writer.AttachmentWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataSource;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.exceptions.OXAborted;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentRequest
extends CommonRequest {
    private static final AttachmentParser PARSER = new AttachmentParser();
    private static final AttachmentBase ATTACHMENT_BASE = Attachment.ATTACHMENT_BASE;
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentRequest.class);
    private static final String DATASOURCE = "datasource";
    private static final String IDENTIFIER = "identifier";
    private final UserConfiguration userConfig;
    private final User user;
    private final Context ctx;
    private final Session session;

    public AttachmentRequest(Session session, Context ctx, JSONWriter w) {
        this(ServerSessionAdapter.valueOf(session, ctx), w);
    }

    public AttachmentRequest(ServerSession session, JSONWriter w) {
        super(w);
        this.ctx = session.getContext();
        this.user = session.getUser();
        this.userConfig = session.getUserConfiguration();
        this.session = session;
    }

    private static Locale localeFrom(ServerSession session) {
        if (null == session) {
            return Locale.US;
        }
        return session.getUser().getLocale();
    }

    private static Locale localeFrom(Session session) throws OXException {
        if (null == session) {
            return Locale.US;
        }
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser().getLocale();
        }
        return UserStorage.getInstance().getUser(session.getUserId(), session.getContextId()).getLocale();
    }

    public static boolean hasPermission(UserConfiguration userConfig) {
        return userConfig.hasCalendar() || userConfig.hasContact() || userConfig.hasTask();
    }

    public boolean action(String action, SimpleRequest req) {
        LOG.debug("Attachments: {} {}", (Object)action, (Object)req);
        try {
            if ("attach".equals(action)) {
                long ts;
                InputStream is;
                String contentTypeS;
                Data data;
                JSONObject object = (JSONObject)req.getBody();
                for (AttachmentField required : Attachment.REQUIRED) {
                    if (object.has(required.getName())) continue;
                    this.missingParameter(required.getName(), action);
                    return true;
                }
                if (!object.has(DATASOURCE)) {
                    this.missingParameter(DATASOURCE, action);
                    return true;
                }
                AttachmentMetadata attachment = PARSER.getAttachmentMetadata(object);
                ConversionService conversionService = ServerServiceRegistry.getInstance().getService(ConversionService.class);
                if (conversionService == null) {
                    throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ConversionService.class.getName()});
                }
                JSONObject datasourceDef = object.getJSONObject(DATASOURCE);
                String datasourceIdentifier = datasourceDef.getString(IDENTIFIER);
                DataSource source = conversionService.getDataSource(datasourceIdentifier);
                if (source == null) {
                    this.invalidParameter(DATASOURCE, datasourceIdentifier);
                    return true;
                }
                List<Class> types = Arrays.asList(source.getTypes());
                HashMap<String, String> arguments = new HashMap<String, String>();
                for (String key : datasourceDef.keySet()) {
                    arguments.put(key, datasourceDef.getString(key));
                }
                if (types.contains(InputStream.class)) {
                    String name;
                    data = source.getData(InputStream.class, new DataArguments(arguments), this.session);
                    String sizeS = data.getDataProperties().get("com.openexchange.conversion.size");
                    contentTypeS = data.getDataProperties().get("com.openexchange.conversion.content-type");
                    if (sizeS != null) {
                        attachment.setFilesize(Long.parseLong(sizeS));
                    }
                    if (contentTypeS != null) {
                        attachment.setFileMIMEType(contentTypeS);
                    }
                    if ((name = data.getDataProperties().get("com.openexchange.conversion.name")) != null && null == attachment.getFilename()) {
                        attachment.setFilename(name);
                    }
                    is = (InputStream)data.getData();
                } else if (types.contains(byte[].class)) {
                    String name;
                    data = source.getData(byte[].class, new DataArguments(arguments), this.session);
                    byte[] bytes = (byte[])data.getData();
                    is = new ByteArrayInputStream(bytes);
                    attachment.setFilesize(bytes.length);
                    contentTypeS = data.getDataProperties().get("com.openexchange.conversion.content-type");
                    if (contentTypeS != null) {
                        attachment.setFileMIMEType(contentTypeS);
                    }
                    if ((name = data.getDataProperties().get("com.openexchange.conversion.name")) != null && null == attachment.getFilename()) {
                        attachment.setFilename(name);
                    }
                } else {
                    this.invalidParameter(DATASOURCE, datasourceIdentifier);
                    return true;
                }
                if (attachment.getFilename() == null) {
                    attachment.setFilename("unknown" + System.currentTimeMillis());
                }
                attachment.setId(0);
                ATTACHMENT_BASE.startTransaction();
                try {
                    ts = ATTACHMENT_BASE.attachToObject(attachment, is, this.session, this.ctx, this.user, this.userConfig);
                    ATTACHMENT_BASE.commit();
                }
                catch (OXException x) {
                    ATTACHMENT_BASE.rollback();
                    throw x;
                }
                finally {
                    ATTACHMENT_BASE.finish();
                }
                Response resp = new Response(this.session);
                resp.setData(attachment.getId());
                resp.setTimestamp(new Date(ts));
                ResponseWriter.write(resp, this.w, AttachmentRequest.localeFrom(this.session));
                return true;
            }
            if ("get".equals(action)) {
                if (!this.checkRequired(req, "folder", "attached", "module", "id")) {
                    return true;
                }
                int folderId = this.requireNumber(req, "folder");
                int attachedId = this.requireNumber(req, "attached");
                int moduleId = this.requireNumber(req, "module");
                int id = this.requireNumber(req, "id");
                this.get(folderId, attachedId, moduleId, id);
                return true;
            }
            if ("updates".equals(action)) {
                if (!this.checkRequired(req, "folder", "module", "attached", "timestamp")) {
                    return true;
                }
                int folderId = this.requireNumber(req, "folder");
                int attachedId = this.requireNumber(req, "attached");
                int moduleId = this.requireNumber(req, "module");
                long timestamp = -1L;
                try {
                    timestamp = Long.parseLong(req.getParameter("timestamp"));
                }
                catch (NumberFormatException nfe) {
                    this.numberError("timestamp", req.getParameter("timestamp"));
                }
                AttachmentField[] columns = PARSER.getColumns(req.getParameterValues("columns"));
                AttachmentField sort = null;
                if (null != req.getParameter("sort")) {
                    sort = AttachmentField.get(Integer.parseInt(req.getParameter("sort")));
                }
                int order = 1;
                if ("DESC".equalsIgnoreCase(req.getParameter("order"))) {
                    order = -1;
                }
                String delete = req.getParameter("ignore");
                String timeZoneId = req.getParameter("timezone");
                this.updates(folderId, attachedId, moduleId, timestamp, "deleted".equals(delete), columns, sort, order, timeZoneId);
                return true;
            }
            if ("all".equals(action)) {
                if (!this.checkRequired(req, "folder", "module", "attached")) {
                    return true;
                }
                int folderId = this.requireNumber(req, "folder");
                int attachedId = this.requireNumber(req, "attached");
                int moduleId = this.requireNumber(req, "module");
                AttachmentField[] columns = PARSER.getColumns(req.getParameterValues("columns"));
                AttachmentField sort = null;
                if (null != req.getParameter("sort")) {
                    sort = AttachmentField.get(Integer.parseInt(req.getParameter("sort")));
                }
                int order = 1;
                if ("DESC".equalsIgnoreCase(req.getParameter("order"))) {
                    order = -1;
                }
                this.all(folderId, attachedId, moduleId, columns, sort, order);
                return true;
            }
            if ("detach".equals(action) || "list".equals(action)) {
                if (!this.checkRequired(req, "folder", "module", "attached")) {
                    return true;
                }
                int folderId = this.requireNumber(req, "folder");
                int attachedId = this.requireNumber(req, "attached");
                int moduleId = this.requireNumber(req, "module");
                JSONArray idsArray = (JSONArray)req.getBody();
                int[] ids = new int[idsArray.length()];
                for (int i = 0; i < idsArray.length(); ++i) {
                    try {
                        ids[i] = idsArray.getInt(i);
                        continue;
                    }
                    catch (JSONException e) {
                        try {
                            ids[i] = Integer.parseInt(idsArray.getString(i));
                            continue;
                        }
                        catch (NumberFormatException e1) {
                            this.handle(e1, this.session);
                            continue;
                        }
                        catch (JSONException e1) {
                            this.handle(e1, this.session);
                        }
                    }
                }
                if ("detach".equals(action)) {
                    this.detach(folderId, attachedId, moduleId, ids);
                } else {
                    String timeZoneId = null;
                    AttachmentField[] columns = PARSER.getColumns(req.getParameterValues("columns"));
                    this.list(folderId, attachedId, moduleId, ids, columns, timeZoneId);
                }
                return true;
            }
        }
        catch (AttachmentParser.UnknownColumnException e) {
            this.handle((Throwable)((Object)e), this.session);
        }
        catch (OXAborted x) {
            return true;
        }
        catch (JSONException e) {
            this.handle(e, this.session);
        }
        catch (OXException e) {
            this.handle(e, this.session);
        }
        return false;
    }

    private int requireNumber(SimpleRequest req, String parameter) {
        String value = req.getParameter(parameter);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            this.numberError(parameter, value);
            throw new OXAborted();
        }
    }

    public void numberError(String parameter, String value) {
        this.handle(AttachmentExceptionCodes.INVALID_REQUEST_PARAMETER.create(parameter, value), this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get(int folderId, int attachedId, int moduleId, int id) {
        try {
            ATTACHMENT_BASE.startTransaction();
            AttachmentMetadata attachment = ATTACHMENT_BASE.getAttachment(this.session, folderId, attachedId, moduleId, id, this.ctx, this.user, this.userConfig);
            AttachmentWriter aWriter = new AttachmentWriter(this.w);
            aWriter.timedResult(attachment.getCreationDate().getTime());
            aWriter.write(attachment, TimeZoneUtils.getTimeZone(this.user.getTimeZone()));
            aWriter.endTimedResult();
            ATTACHMENT_BASE.commit();
        }
        catch (Throwable t) {
            try {
                ATTACHMENT_BASE.rollback();
            }
            catch (OXException e) {
                LOG.debug("", (Throwable)e);
            }
            this.handle(t, this.session);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updates(int folderId, int attachedId, int moduleId, long ts, boolean ignoreDeleted, AttachmentField[] fields, AttachmentField sort, int order, String timeZoneId) {
        SearchIterator iter = null;
        SearchIterator iter2 = null;
        try {
            ATTACHMENT_BASE.startTransaction();
            Delta<AttachmentMetadata> delta = sort != null ? ATTACHMENT_BASE.getDelta(this.session, folderId, attachedId, moduleId, ts, ignoreDeleted, fields, sort, order, this.ctx, this.user, this.userConfig) : ATTACHMENT_BASE.getDelta(this.session, folderId, attachedId, moduleId, ts, ignoreDeleted, this.ctx, this.user, this.userConfig);
            iter = delta.results();
            iter2 = delta.getDeleted();
            AttachmentWriter aWriter = new AttachmentWriter(this.w);
            aWriter.timedResult(delta.sequenceNumber());
            aWriter.writeDelta(iter, iter2, fields, ignoreDeleted, null == timeZoneId ? TimeZoneUtils.getTimeZone(this.user.getTimeZone()) : TimeZoneUtils.getTimeZone(timeZoneId));
            aWriter.endTimedResult();
            ATTACHMENT_BASE.commit();
        }
        catch (Throwable t) {
            try {
                ATTACHMENT_BASE.rollback();
            }
            catch (OXException e) {
                LOG.debug("", (Throwable)e);
            }
            this.handle(t, this.session);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (OXException e1) {
                    LOG.error("", (Throwable)e1);
                }
            }
            if (iter2 != null) {
                try {
                    iter2.close();
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void all(int folderId, int attachedId, int moduleId, AttachmentField[] fields, AttachmentField sort, int order) {
        SearchIterator iter = null;
        try {
            ATTACHMENT_BASE.startTransaction();
            TimedResult<AttachmentMetadata> result = sort != null ? ATTACHMENT_BASE.getAttachments(this.session, folderId, attachedId, moduleId, fields, sort, order, this.ctx, this.user, this.userConfig) : ATTACHMENT_BASE.getAttachments(this.session, folderId, attachedId, moduleId, this.ctx, this.user, this.userConfig);
            iter = result.results();
            AttachmentWriter aWriter = new AttachmentWriter(this.w);
            aWriter.timedResult(result.sequenceNumber());
            aWriter.writeAttachments(iter, fields, TimeZoneUtils.getTimeZone(this.user.getTimeZone()));
            aWriter.endTimedResult();
            ATTACHMENT_BASE.commit();
        }
        catch (Throwable t) {
            try {
                ATTACHMENT_BASE.rollback();
            }
            catch (OXException e) {
                LOG.debug("", (Throwable)e);
            }
            this.handle(t, this.session);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach(int folderId, int attachedId, int moduleId, int[] ids) {
        Response resp;
        long timestamp = 0L;
        try {
            ATTACHMENT_BASE.startTransaction();
            timestamp = ATTACHMENT_BASE.detachFromObject(folderId, attachedId, moduleId, ids, this.session, this.ctx, this.user, this.userConfig);
            ATTACHMENT_BASE.commit();
        }
        catch (Throwable t) {
            try {
                ATTACHMENT_BASE.rollback();
            }
            catch (OXException e) {
                LOG.debug("", (Throwable)e);
            }
            this.handle(t, this.session);
            return;
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        try {
            resp = new Response(this.session);
        }
        catch (OXException e) {
            resp = new Response();
        }
        resp.setData("");
        resp.setTimestamp(new Date(timestamp));
        try {
            ResponseWriter.write(resp, this.w, AttachmentRequest.localeFrom(this.session));
        }
        catch (JSONException e) {
            LOG.debug("Cannot contact client", (Throwable)e);
        }
        catch (OXException e) {
            LOG.debug("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void list(int folderId, int attachedId, int moduleId, int[] ids, AttachmentField[] fields, String timeZoneId) {
        SearchIterator iter = null;
        TimeZone tz = null == timeZoneId ? TimeZoneUtils.getTimeZone(this.user.getTimeZone()) : TimeZoneUtils.getTimeZone(timeZoneId);
        try {
            ATTACHMENT_BASE.startTransaction();
            TimedResult<AttachmentMetadata> result = ATTACHMENT_BASE.getAttachments(this.session, folderId, attachedId, moduleId, ids, fields, this.ctx, this.user, this.userConfig);
            iter = result.results();
            AttachmentWriter aWriter = new AttachmentWriter(this.w);
            aWriter.timedResult(result.sequenceNumber());
            aWriter.writeAttachments(iter, fields, tz);
            aWriter.endTimedResult();
            ATTACHMENT_BASE.commit();
        }
        catch (Throwable t) {
            try {
                ATTACHMENT_BASE.rollback();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            this.handle(t, this.session);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }
}

