/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.container.DateOrderObject;
import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.parser.AppointmentParser;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.parser.ParticipantParser;
import com.openexchange.ajax.request.CalendarRequest;
import com.openexchange.ajax.writer.AppointmentWriter;
import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.search.AppointmentSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppointmentRequest
extends CalendarRequest {
    private static final int DAY_MILLIS = 86400000;
    private static final Pattern PATTERN_SPLIT = Pattern.compile(",");
    public static final String RECURRENCE_MASTER = "recurrence_master";
    private static final int[] _appointmentFields = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 400, 201, 202, 203, 209, 218, 206, 207, 220, 221, 402, 211, 210, 401, 102, 408, 224, 223, 225, 226, 105, 104};
    private final Context ctx;
    private final User user;
    private final AppointmentSqlFactoryService appointmentFactory;
    private static final Logger LOG = LoggerFactory.getLogger(AppointmentRequest.class);

    private static String[] split(String csv) {
        return PATTERN_SPLIT.split(csv, 0);
    }

    public AppointmentRequest(ServerSession session) {
        this.session = session;
        this.ctx = session.getContext();
        this.user = session.getUser();
        String sTimeZone = this.user.getTimeZone();
        this.appointmentFactory = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class);
        this.timeZone = TimeZoneUtils.getTimeZone(sTimeZone);
        LOG.debug("use timezone string: {}", (Object)sTimeZone);
        LOG.debug("use user timezone: {}", (Object)this.timeZone);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public JSONValue action(String action, JSONObject jsonObject) throws JSONException, OXException {
        if (!this.session.getUserPermissionBits().hasCalendar()) {
            throw AjaxExceptionCodes.NO_PERMISSION_FOR_MODULE.create("calendar");
        }
        if ("confirm".equalsIgnoreCase(action)) {
            return this.actionConfirm(jsonObject);
        }
        if ("new".equalsIgnoreCase(action)) {
            return this.actionNew(jsonObject);
        }
        if ("delete".equalsIgnoreCase(action)) {
            return this.actionDelete(jsonObject);
        }
        if ("update".equalsIgnoreCase(action)) {
            return this.actionUpdate(jsonObject);
        }
        if ("updates".equalsIgnoreCase(action)) {
            return this.actionUpdates(jsonObject);
        }
        if ("list".equalsIgnoreCase(action)) {
            return this.actionList(jsonObject);
        }
        if ("all".equalsIgnoreCase(action)) {
            return this.actionAll(jsonObject);
        }
        if ("get".equalsIgnoreCase(action)) {
            return this.actionGet(jsonObject);
        }
        if ("search".equalsIgnoreCase(action)) {
            return this.actionSearch(jsonObject);
        }
        if ("newappointments".equalsIgnoreCase(action)) {
            return this.actionNewAppointmentsSearch(jsonObject);
        }
        if ("has".equalsIgnoreCase(action)) {
            return this.actionHas(jsonObject);
        }
        if ("freebusy".equalsIgnoreCase(action)) {
            return this.actionFreeBusy(jsonObject);
        }
        if ("copy".equalsIgnoreCase(action)) {
            return this.actionCopy(jsonObject);
        }
        if ("resolveuid".equalsIgnoreCase(action)) {
            return this.actionResolveUid(jsonObject);
        }
        throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
    }

    private JSONObject actionResolveUid(JSONObject jsonObj) throws JSONException, OXException {
        AppointmentSQLInterface appointmentSql = this.appointmentFactory.createAppointmentSql(this.session);
        JSONObject json = new JSONObject();
        String uid = DataParser.parseString(jsonObj, "uid");
        int id = appointmentSql.resolveUid(uid);
        if (id == 0) {
            throw OXException.notFound((String)"");
        }
        json.put("id", id);
        return json;
    }

    public JSONObject actionNew(JSONObject jsonObj) throws JSONException, OXException {
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        CalendarDataObject appointmentObj = new CalendarDataObject();
        appointmentObj.setContext(this.ctx);
        AppointmentParser appointmentParser = new AppointmentParser(timeZone);
        appointmentParser.parse(appointmentObj, jData);
        if (!appointmentObj.containsParentFolderID()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("folder");
        }
        this.convertExternalToInternalUsersIfPossible(appointmentObj, this.ctx, LOG);
        AppointmentSQLInterface appointmentSql = this.appointmentFactory.createAppointmentSql(this.session);
        Appointment[] conflicts = appointmentSql.insertAppointmentObject(appointmentObj);
        JSONObject jsonResponseObj = new JSONObject();
        if (conflicts == null) {
            jsonResponseObj.put("id", appointmentObj.getObjectID());
            this.timestamp = appointmentObj.getLastModified();
        } else {
            JSONArray jsonConflictArray = new JSONArray(conflicts.length);
            AppointmentWriter appointmentWriter = new AppointmentWriter(timeZone).setSession(this.session);
            for (int a = 0; a < conflicts.length; ++a) {
                JSONObject jsonAppointmentObj = new JSONObject();
                appointmentWriter.writeAppointment(conflicts[a], jsonAppointmentObj);
                jsonConflictArray.put((Object)jsonAppointmentObj);
            }
            jsonResponseObj.put("conflicts", (Object)jsonConflictArray);
        }
        return jsonResponseObj;
    }

    public JSONObject actionUpdate(JSONObject jsonObj) throws JSONException, OXException {
        int objectId = DataParser.checkInt(jsonObj, "id");
        int inFolder = DataParser.checkInt(jsonObj, "folder");
        this.timestamp = DataParser.checkDate(jsonObj, "timestamp");
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        CalendarDataObject appointmentObj = new CalendarDataObject();
        appointmentObj.setContext(this.ctx);
        AppointmentParser appointmentParser = new AppointmentParser(timeZone);
        appointmentParser.parse(appointmentObj, jData);
        this.convertExternalToInternalUsersIfPossible(appointmentObj, this.ctx, LOG);
        appointmentObj.setObjectID(objectId);
        AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
        Appointment[] conflicts = appointmentsql.updateAppointmentObject(appointmentObj, inFolder, this.timestamp);
        JSONObject jsonResponseObj = new JSONObject();
        if (conflicts == null) {
            jsonResponseObj.put("id", appointmentObj.getObjectID());
            this.timestamp = appointmentObj.getLastModified();
        } else {
            JSONArray jsonConflictArray = new JSONArray(conflicts.length);
            AppointmentWriter appointmentWriter = new AppointmentWriter(timeZone).setSession(this.session);
            for (int a = 0; a < conflicts.length; ++a) {
                JSONObject jsonAppointmentObj = new JSONObject();
                appointmentWriter.writeAppointment(conflicts[a], jsonAppointmentObj);
                jsonConflictArray.put((Object)jsonAppointmentObj);
            }
            jsonResponseObj.put("conflicts", (Object)jsonConflictArray);
        }
        return jsonResponseObj;
    }

    public JSONArray actionUpdates(JSONObject jsonObj) throws JSONException, OXException {
        String[] sColumns = AppointmentRequest.split(DataParser.checkString(jsonObj, "columns"));
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        Date requestedTimestamp = DataParser.checkDate(jsonObj, "timestamp");
        this.timestamp = new Date(requestedTimestamp.getTime());
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        Date startUTC = DataParser.parseDate(jsonObj, "start");
        Date endUTC = DataParser.parseDate(jsonObj, "end");
        Date start = startUTC == null ? null : this.applyTimeZone2Date(startUTC.getTime());
        Date end = endUTC == null ? null : this.applyTimeZone2Date(endUTC.getTime());
        String ignore = DataParser.parseString(jsonObj, "ignore");
        boolean bRecurrenceMaster = DataParser.parseBoolean(jsonObj, RECURRENCE_MASTER);
        boolean showPrivates = DataParser.parseBoolean(jsonObj, "showPrivate");
        int folderId = DataParser.parseInt(jsonObj, "folder");
        boolean showAppointmentInAllFolders = false;
        if (folderId == 0) {
            showAppointmentInAllFolders = true;
        }
        boolean bIgnoreDelete = false;
        boolean bIgnoreModified = false;
        if (ignore != null && ignore.indexOf("deleted") != -1) {
            bIgnoreDelete = true;
        }
        if (ignore != null && ignore.indexOf("changed") != -1) {
            bIgnoreModified = true;
        }
        JSONArray jsonResponseArray = new JSONArray();
        if (bIgnoreModified && bIgnoreDelete) {
            return jsonResponseArray;
        }
        AppointmentWriter appointmentWriter = new AppointmentWriter(timeZone).setSession(this.session);
        AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        SearchIterator<Appointment> it = null;
        Date lastModified = null;
        appointmentsql.setIncludePrivateAppointments(showPrivates);
        try {
            Object appointmentObj;
            block25: {
                if (bIgnoreModified) break block25;
                it = showAppointmentInAllFolders ? appointmentsql.getModifiedAppointmentsBetween(this.session.getUserId(), start, end, _appointmentFields, requestedTimestamp, 0, Order.NO_ORDER) : (start == null || end == null ? appointmentsql.getModifiedAppointmentsInFolder(folderId, _appointmentFields, requestedTimestamp) : appointmentsql.getModifiedAppointmentsInFolder(folderId, start, end, _appointmentFields, requestedTimestamp));
                while (it.hasNext()) {
                    boolean written;
                    block26: {
                        RecurringResultsInterface recuResults;
                        block27: {
                            block28: {
                                appointmentObj = (Appointment)it.next();
                                written = false;
                                if (((CalendarObject)appointmentObj).getRecurrenceType() == 0 || ((CalendarObject)appointmentObj).getRecurrencePosition() != 0) break block26;
                                if (!bRecurrenceMaster) break block27;
                                recuResults = null;
                                try {
                                    recuResults = recColl.calculateFirstRecurring((CalendarObject)appointmentObj);
                                    written = true;
                                }
                                catch (OXException e) {
                                    LOG.error("Can not calculate recurrence {}:{}", new Object[]{((DataObject)appointmentObj).getObjectID(), this.ctx.getContextId(), e});
                                }
                                if (recuResults == null || recuResults.size() == 1) break block28;
                                LOG.warn("cannot load first recurring appointment from appointment object: {} / {}\n\n\n", (Object)((CalendarObject)appointmentObj).getRecurrenceType(), (Object)((DataObject)appointmentObj).getObjectID());
                                break block26;
                            }
                            if (recuResults == null) break block26;
                            ((CalendarObject)appointmentObj).setStartDate(new Date(recuResults.getRecurringResult(0).getStart()));
                            ((CalendarObject)appointmentObj).setEndDate(new Date(recuResults.getRecurringResult(0).getEnd()));
                            appointmentWriter.writeArray((Appointment)appointmentObj, columns, jsonResponseArray);
                            break block26;
                        }
                        recuResults = null;
                        try {
                            if (start == null || end == null) {
                                recuResults = recColl.calculateFirstRecurring((CalendarObject)appointmentObj);
                                written = true;
                            } else {
                                recuResults = recColl.calculateRecurring((CalendarObject)appointmentObj, start.getTime(), end.getTime(), 0);
                                written = true;
                            }
                        }
                        catch (OXException e) {
                            LOG.error("Can not calculate recurrence {}:{}", new Object[]{((DataObject)appointmentObj).getObjectID(), this.ctx.getContextId(), e});
                        }
                        if (recuResults != null) {
                            for (int a = 0; a < recuResults.size(); ++a) {
                                RecurringResultInterface result = recuResults.getRecurringResult(a);
                                ((CalendarObject)appointmentObj).setStartDate(new Date(result.getStart()));
                                ((CalendarObject)appointmentObj).setEndDate(new Date(result.getEnd()));
                                ((CalendarObject)appointmentObj).setRecurrencePosition(result.getPosition());
                                if (startUTC == null || endUTC == null) {
                                    appointmentWriter.writeArray((Appointment)appointmentObj, columns, jsonResponseArray);
                                    continue;
                                }
                                appointmentWriter.writeArray((Appointment)appointmentObj, columns, startUTC, endUTC, jsonResponseArray);
                            }
                        }
                    }
                    if (!written) {
                        if (startUTC == null || endUTC == null) {
                            appointmentWriter.writeArray((Appointment)appointmentObj, columns, jsonResponseArray);
                        } else {
                            appointmentWriter.writeArray((Appointment)appointmentObj, columns, startUTC, endUTC, jsonResponseArray);
                        }
                    }
                    lastModified = ((DataObject)appointmentObj).getLastModified();
                    if (this.timestamp.getTime() >= lastModified.getTime()) continue;
                    this.timestamp = lastModified;
                }
            }
            if (!bIgnoreDelete) {
                it = appointmentsql.getDeletedAppointmentsInFolder(folderId, _appointmentFields, requestedTimestamp);
                while (it.hasNext()) {
                    appointmentObj = (Appointment)it.next();
                    jsonResponseArray.put(((DataObject)appointmentObj).getObjectID());
                    lastModified = ((DataObject)appointmentObj).getLastModified();
                    if (this.timestamp.getTime() >= lastModified.getTime()) continue;
                    this.timestamp = lastModified;
                }
            }
            appointmentObj = jsonResponseArray;
            return appointmentObj;
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONArray actionDelete(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = DataParser.checkDate(jsonObj, "timestamp");
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        CalendarDataObject appointmentObj = new CalendarDataObject();
        appointmentObj.setObjectID(DataParser.checkInt(jData, "id"));
        int inFolder = DataParser.checkInt(jData, "folder");
        if (jData.has("recurrence_position")) {
            appointmentObj.setRecurrencePosition(DataParser.checkInt(jData, "recurrence_position"));
        } else if (jData.has("recurrence_date_position")) {
            appointmentObj.setRecurrenceDatePosition(DataParser.checkDate(jData, "recurrence_date_position"));
        }
        appointmentObj.setContext(this.ctx);
        AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
        try {
            appointmentsql.deleteAppointmentObject(appointmentObj, inFolder, this.timestamp);
            if (appointmentObj.getLastModified() != null) {
                this.timestamp = appointmentObj.getLastModified();
            }
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        return new JSONArray();
    }

    public JSONArray actionList(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = new Date(0L);
        Date lastModified = null;
        SearchIterator<Appointment> it = null;
        TIntObjectHashMap recurrencePositionMap = new TIntObjectHashMap();
        String[] sColumns = AppointmentRequest.split(DataParser.checkString(jsonObj, "columns"));
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        JSONArray jData = DataParser.checkJSONArray(jsonObj, "data");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        boolean bRecurrenceMaster = DataParser.parseBoolean(jsonObj, RECURRENCE_MASTER);
        TIntIntHashMap objectIdMap = new TIntIntHashMap();
        for (int a = 0; a < jData.length(); ++a) {
            JSONObject jObject = null;
            try {
                jObject = jData.getJSONObject(a);
            }
            catch (JSONException e) {
                throw OXJSONExceptionCodes.JSON_READ_ERROR.create(e, jData.toString());
            }
            int objectId = DataParser.checkInt(jObject, "id");
            int folderId = DataParser.checkInt(jObject, "folder");
            objectIdMap.put(objectId, folderId);
            int tempRecurrencePosition = DataParser.parseInt(jObject, "recurrence_position");
            if (tempRecurrencePosition == 0 && (tempRecurrencePosition = DataParser.parseInt(jObject, "pos")) > 0) {
                LOG.warn("found old recurrence position field in request");
            }
            if (tempRecurrencePosition <= 0) continue;
            int recurrencePosition = tempRecurrencePosition;
            TIntArrayList recurrencePosList = null;
            recurrencePosList = recurrencePositionMap.containsKey(objectId) ? (TIntArrayList)recurrencePositionMap.get(objectId) : new TIntArrayList();
            recurrencePosList.add(recurrencePosition);
            recurrencePositionMap.put(objectId, (Object)recurrencePosList);
        }
        int size = objectIdMap.size();
        int[][] objectIdAndFolderId = new int[size][2];
        int i = 0;
        int[] arr$ = objectIdMap.keys();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int objectId;
            objectIdAndFolderId[i][0] = objectId = arr$[i$];
            objectIdAndFolderId[i++][1] = objectIdMap.get(objectId);
        }
        AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        it = appointmentsql.getObjectsById(objectIdAndFolderId, _appointmentFields);
        try {
            int counter = 0;
            JSONArray jsonResponseArray = new JSONArray();
            while (it.hasNext()) {
                Appointment appointment = (Appointment)it.next();
                if (null == appointment) continue;
                AppointmentWriter appointmentwriter = new AppointmentWriter(timeZone).setSession(this.session);
                Date startDate = appointment.getStartDate();
                Date endDate = appointment.getEndDate();
                if (appointment.getRecurrenceType() != 0 && appointment.getRecurrencePosition() == 0) {
                    RecurringResultsInterface recuResults;
                    if (bRecurrenceMaster) {
                        recuResults = null;
                        try {
                            recuResults = recColl.calculateFirstRecurring(appointment);
                        }
                        catch (OXException e) {
                            LOG.error("Can not calculate recurrence {}:{}", new Object[]{appointment.getObjectID(), this.ctx.getContextId(), e});
                            appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                        }
                        if (recuResults != null && recuResults.size() == 1) {
                            appointment.setStartDate(new Date(recuResults.getRecurringResult(0).getStart()));
                            appointment.setEndDate(new Date(recuResults.getRecurringResult(0).getEnd()));
                            appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                        } else {
                            LOG.warn("cannot load first recurring appointment from appointment object: {} / {}\n\n\n", (Object)appointment.getRecurrenceType(), (Object)appointment.getObjectID());
                        }
                    } else if (recurrencePositionMap.containsKey(appointment.getObjectID())) {
                        TIntList recurrencePosList = (TIntList)recurrencePositionMap.get(appointment.getObjectID());
                        int listSize = recurrencePosList.size();
                        for (int a = 0; a < listSize; ++a) {
                            appointment.setStartDate(startDate);
                            appointment.setEndDate(endDate);
                            RecurringResultsInterface recuResults2 = recColl.calculateRecurring(appointment, 0L, 0L, recurrencePosList.get(a));
                            if (recuResults2.size() <= 0) {
                                throw OXException.notFound((String)("no recurrence appointment found at pos: " + counter));
                            }
                            RecurringResultInterface result = recuResults2.getRecurringResult(0);
                            appointment.setStartDate(new Date(result.getStart()));
                            appointment.setEndDate(new Date(result.getEnd()));
                            appointment.setRecurrencePosition(result.getPosition());
                            appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                        }
                    } else {
                        recuResults = null;
                        try {
                            recuResults = recColl.calculateFirstRecurring(appointment);
                        }
                        catch (OXException e) {
                            LOG.error("Can not calculate recurrence {}:{}", new Object[]{appointment.getObjectID(), this.ctx.getContextId(), e});
                            appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                        }
                        if (recuResults != null && recuResults.size() > 0) {
                            RecurringResultInterface result = recuResults.getRecurringResult(0);
                            appointment.setStartDate(new Date(result.getStart()));
                            appointment.setEndDate(new Date(result.getEnd()));
                            appointment.setRecurrencePosition(result.getPosition());
                        } else if (recuResults != null) {
                            throw OXException.notFound((String)("no recurrence appointment found at pos: " + counter));
                        }
                        if (appointment.getFullTime() && appointment.getStartDate().getTime() == appointment.getEndDate().getTime()) {
                            appointment.setEndDate(new Date(appointment.getStartDate().getTime() + 86400000L));
                        }
                        appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                    }
                } else {
                    appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                }
                lastModified = appointment.getLastModified();
                if (this.timestamp.getTime() < lastModified.getTime()) {
                    this.timestamp = lastModified;
                }
                ++counter;
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        catch (SearchIteratorException e) {
            throw e;
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONArray actionAll(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = new Date(0L);
        SearchIterator<Appointment> it = null;
        String[] sColumns = AppointmentRequest.split(DataParser.checkString(jsonObj, "columns"));
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        Date startUTC = DataParser.checkDate(jsonObj, "start");
        Date endUTC = DataParser.checkDate(jsonObj, "end");
        Date start = this.applyTimeZone2Date(startUTC.getTime());
        Date end = this.applyTimeZone2Date(endUTC.getTime());
        int folderId = DataParser.parseInt(jsonObj, "folder");
        int orderBy = DataParser.parseInt(jsonObj, "sort");
        boolean showPrivateAppointments = DataParser.parseBoolean(jsonObj, "showPrivate");
        boolean listOrder = orderBy == 201 || orderBy == 202;
        ArrayList<DateOrderObject> objectList = new ArrayList<DateOrderObject>();
        String orderDirString = DataParser.parseString(jsonObj, "order");
        Order orderDir = OrderFields.parse(orderDirString);
        boolean bRecurrenceMaster = DataParser.parseBoolean(jsonObj, RECURRENCE_MASTER);
        int leftHandLimit = DataParser.parseInt(jsonObj, "left_hand_limit");
        int rightHandLimit = DataParser.parseInt(jsonObj, "right_hand_limit");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        boolean showAppointmentInAllFolders = false;
        if (folderId == 0) {
            showAppointmentInAllFolders = true;
        }
        JSONArray jsonResponseArray = new JSONArray();
        try {
            AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
            CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
            if (showAppointmentInAllFolders) {
                it = appointmentsql.getAppointmentsBetween(this.user.getId(), start, end, _appointmentFields, orderBy, orderDir);
            } else {
                boolean old = appointmentsql.getIncludePrivateAppointments();
                appointmentsql.setIncludePrivateAppointments(showPrivateAppointments);
                it = appointmentsql.getAppointmentsBetweenInFolder(folderId, _appointmentFields, start, end, orderBy, orderDir);
                appointmentsql.setIncludePrivateAppointments(old);
            }
            Date lastModified = new Date(0L);
            while (it.hasNext()) {
                Appointment appointment = (Appointment)it.next();
                AppointmentWriter writer = new AppointmentWriter(timeZone).setSession(this.session);
                boolean written = false;
                if (Arrays.contains((int[])columns, (int)204) && !appointment.containsAlarm() && appointment.containsUserParticipants()) {
                    OXFolderAccess ofa = new OXFolderAccess(this.ctx);
                    try {
                        int folderType = ofa.getFolderType(appointment.getParentFolderID(), this.user.getId());
                        int owner = ofa.getFolderOwner(appointment.getParentFolderID());
                        block5 : switch (folderType) {
                            case 1: {
                                for (UserParticipant u : appointment.getUsers()) {
                                    if (u.getIdentifier() != this.user.getId() || u.getAlarmMinutes() <= -1) continue;
                                    appointment.setAlarm(u.getAlarmMinutes());
                                    break block5;
                                }
                                break;
                            }
                            case 3: {
                                for (UserParticipant u : appointment.getUsers()) {
                                    if (u.getIdentifier() != owner || u.getAlarmMinutes() <= -1) continue;
                                    appointment.setAlarm(u.getAlarmMinutes());
                                    break block5;
                                }
                                break;
                            }
                        }
                    }
                    catch (OXException e) {
                        LOG.error("An error occurred during filling an appointment with alarm information.", (Throwable)e);
                    }
                }
                if (appointment.getRecurrenceType() != 0 && appointment.getRecurrencePosition() == 0) {
                    RecurringResultsInterface recuResults;
                    if (bRecurrenceMaster) {
                        recuResults = null;
                        try {
                            recuResults = recColl.calculateFirstRecurring(appointment);
                            written = true;
                        }
                        catch (OXException e) {
                            LOG.error("Can not calculate recurrence {}:{}", new Object[]{appointment.getObjectID(), this.ctx.getContextId(), e});
                        }
                        if (recuResults != null && recuResults.size() == 1) {
                            appointment.setStartDate(new Date(recuResults.getRecurringResult(0).getStart()));
                            appointment.setEndDate(new Date(recuResults.getRecurringResult(0).getEnd()));
                            writer.writeArray(appointment, columns, jsonResponseArray);
                        } else {
                            LOG.warn("cannot load first recurring appointment from appointment object: {} / {}\n\n\n", (Object)appointment.getRecurrenceType(), (Object)appointment.getObjectID());
                        }
                    } else {
                        recuResults = null;
                        try {
                            recuResults = recColl.calculateRecurring(appointment, start.getTime(), end.getTime(), 0);
                            written = true;
                        }
                        catch (OXException e) {
                            LOG.error("Can not calculate recurrence {}:{}", new Object[]{appointment.getObjectID(), this.ctx.getContextId(), e});
                        }
                        if (recuResults != null) {
                            for (int a = 0; a < recuResults.size(); ++a) {
                                RecurringResultInterface result = recuResults.getRecurringResult(a);
                                appointment.setStartDate(new Date(result.getStart()));
                                appointment.setEndDate(new Date(result.getEnd()));
                                appointment.setRecurrencePosition(result.getPosition());
                                if (listOrder) {
                                    DateOrderObject dateOrderObject = new DateOrderObject(this.getDateByFieldId(orderBy, appointment, timeZone), appointment.clone());
                                    objectList.add(dateOrderObject);
                                    continue;
                                }
                                writer.writeArray(appointment, columns, startUTC, endUTC, jsonResponseArray);
                            }
                        }
                    }
                }
                if (!written) {
                    if (listOrder) {
                        DateOrderObject dateOrderObject = new DateOrderObject(this.getDateByFieldId(orderBy, appointment, timeZone), appointment.clone());
                        objectList.add(dateOrderObject);
                    } else {
                        writer.writeArray(appointment, columns, startUTC, endUTC, jsonResponseArray);
                    }
                }
                lastModified = appointment.getLastModified();
                if (this.timestamp.getTime() >= lastModified.getTime()) continue;
                this.timestamp = lastModified;
            }
            if (listOrder && !objectList.isEmpty()) {
                AppointmentWriter appointmentwriter = new AppointmentWriter(timeZone).setSession(this.session);
                Object[] dateOrderObjectArray = objectList.toArray(new DateOrderObject[objectList.size()]);
                java.util.Arrays.sort(dateOrderObjectArray);
                switch (orderDir) {
                    case ASCENDING: 
                    case NO_ORDER: {
                        Appointment appointmentObj;
                        int a;
                        for (a = 0; a < dateOrderObjectArray.length; ++a) {
                            appointmentObj = (Appointment)((DateOrderObject)dateOrderObjectArray[a]).getObject();
                            appointmentwriter.writeArray(appointmentObj, columns, startUTC, endUTC, jsonResponseArray);
                        }
                        break;
                    }
                    case DESCENDING: {
                        Appointment appointmentObj;
                        int a;
                        for (a = dateOrderObjectArray.length - 1; a >= 0; --a) {
                            appointmentObj = (Appointment)((DateOrderObject)dateOrderObjectArray[a]).getObject();
                            appointmentwriter.writeArray(appointmentObj, columns, startUTC, endUTC, jsonResponseArray);
                        }
                        break;
                    }
                }
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONObject actionGet(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = null;
        int id = DataParser.checkInt(jsonObj, "id");
        int inFolder = DataParser.checkInt(jsonObj, "folder");
        int recurrencePosition = DataParser.parseInt(jsonObj, "recurrence_position");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        try {
            CalendarDataObject appointmentobject = appointmentsql.getObjectById(id, inFolder);
            if (this.shouldAnonymize(appointmentobject, this.session.getUserId())) {
                this.anonymize(appointmentobject);
            }
            AppointmentWriter appointmentwriter = new AppointmentWriter(timeZone).setSession(this.session);
            appointmentwriter.setSession(this.session);
            JSONObject jsonResponseObj = new JSONObject();
            if (appointmentobject.getRecurrenceType() != 0 && recurrencePosition > 0) {
                RecurringResultsInterface recuResults = recColl.calculateRecurring(appointmentobject, 0L, 0L, recurrencePosition, 999, true);
                if (recuResults.size() == 0) {
                    LOG.warn("No occurrence at position {}", (Object)recurrencePosition);
                    throw OXCalendarExceptionCodes.UNKNOWN_RECURRENCE_POSITION.create(recurrencePosition);
                }
                RecurringResultInterface result = recuResults.getRecurringResult(0);
                appointmentobject.setStartDate(new Date(result.getStart()));
                appointmentobject.setEndDate(new Date(result.getEnd()));
                appointmentobject.setRecurrencePosition(result.getPosition());
                appointmentwriter.writeAppointment(appointmentobject, jsonResponseObj);
            } else {
                appointmentwriter.writeAppointment(appointmentobject, jsonResponseObj);
            }
            this.timestamp = appointmentobject.getLastModified();
            return jsonResponseObj;
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
    }

    public JSONObject actionConfirm(JSONObject jsonObj) throws OXException, OXException, OXException, JSONException {
        int objectId = DataParser.checkInt(jsonObj, "id");
        int folderId = DataParser.checkInt(jsonObj, "folder");
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        ConfirmableParticipant participant = new ParticipantParser().parseConfirmation(true, jData);
        int userId = this.user.getId();
        if (jData.has("id")) {
            userId = DataParser.checkInt(jData, "id");
        }
        String confirmMessage = participant.getMessage();
        int confirmStatus = participant.getConfirm();
        AppointmentSQLInterface appointmentSql = this.appointmentFactory.createAppointmentSql(this.session);
        this.timestamp = null;
        if (participant.getType() == 1 || participant.getType() == 0) {
            this.timestamp = appointmentSql.setUserConfirmation(objectId, folderId, userId, confirmStatus, confirmMessage);
        } else if (participant.getType() == 5) {
            this.timestamp = appointmentSql.setExternalConfirmation(objectId, folderId, participant.getEmailAddress(), confirmStatus, confirmMessage);
        } else {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create("type", jData.get("type"));
        }
        return new JSONObject();
    }

    public JSONArray actionHas(JSONObject jsonObj) throws JSONException, OXException, OXException, OXException {
        Date start = DataParser.checkTime(jsonObj, "start", this.timeZone);
        Date end = DataParser.checkTime(jsonObj, "end", this.timeZone);
        AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
        boolean[] bHas = appointmentsql.hasAppointmentsBetween(start, end);
        JSONArray jsonResponseArray = new JSONArray();
        for (int a = 0; a < bHas.length; ++a) {
            jsonResponseArray.put(bHas[a]);
        }
        return jsonResponseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionSearch(JSONObject jsonObj) throws JSONException, OXException {
        String[] sColumns = AppointmentRequest.split(DataParser.checkString(jsonObj, "columns"));
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        this.timestamp = new Date(0L);
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        AppointmentSearchObject searchObj = new AppointmentSearchObject();
        if (jData.has("folder")) {
            int inFolder = DataParser.parseInt(jData, "folder");
            searchObj.addFolder(inFolder);
        }
        if (jData.has("pattern")) {
            searchObj.setPattern(DataParser.parseString(jData, "pattern"));
        }
        int orderBy = DataParser.parseInt(jsonObj, "sort");
        String orderDirString = DataParser.parseString(jsonObj, "order");
        Order orderDir = OrderFields.parse(orderDirString);
        AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
        SearchIterator<Appointment> it = appointmentsql.searchAppointments(searchObj, orderBy, orderDir, _appointmentFields);
        JSONArray jsonResponseArray = new JSONArray();
        try {
            CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
            AppointmentWriter appointmentwriter = new AppointmentWriter(this.timeZone).setSession(this.session);
            while (it.hasNext()) {
                Appointment appointment = (Appointment)it.next();
                if (appointment.getRecurrenceType() != 0 && appointment.getRecurrencePosition() == 0) {
                    RecurringResultsInterface recuResults = null;
                    try {
                        recuResults = recColl.calculateFirstRecurring(appointment);
                    }
                    catch (OXException x) {
                        LOG.error("Can not calculate recurrence for appointment {} in context {}", new Object[]{appointment.getObjectID(), this.ctx.getContextId(), x});
                        appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                    }
                    if (recuResults != null && recuResults.size() != 1) {
                        LOG.warn("Can not load first recurring appointment from appointment object {}", (Object)appointment.getObjectID());
                        appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                    } else if (recuResults != null) {
                        appointment.setStartDate(new Date(recuResults.getRecurringResult(0).getStart()));
                        appointment.setEndDate(new Date(recuResults.getRecurringResult(0).getEnd()));
                        appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                    }
                } else {
                    appointmentwriter.writeArray(appointment, columns, jsonResponseArray);
                }
                if (appointment.getLastModified() == null || !this.timestamp.before(appointment.getLastModified())) continue;
                this.timestamp = appointment.getLastModified();
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONArray actionNewAppointmentsSearch(JSONObject jsonObj) throws JSONException, OXException {
        String orderDirString;
        String[] sColumns = AppointmentRequest.split(DataParser.checkString(jsonObj, "columns"));
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        Date start = DataParser.checkTime(jsonObj, "start", timeZone);
        Date end = DataParser.checkTime(jsonObj, "end", timeZone);
        Date startUTC = DataParser.checkDate(jsonObj, "start");
        Date endUTC = DataParser.checkDate(jsonObj, "end");
        int orderBy = DataParser.parseInt(jsonObj, "sort");
        if (orderBy == 0) {
            orderBy = 201;
        }
        if ((orderDirString = DataParser.parseString(jsonObj, "order")) == null) {
            orderDirString = "asc";
        }
        Order orderDir = OrderFields.parse(orderDirString);
        int limit = DataParser.checkInt(jsonObj, "limit");
        this.timestamp = new Date(0L);
        Object lastModified = null;
        AppointmentSearchObject searchObj = new AppointmentSearchObject();
        searchObj.setRange(new Date[]{start, end});
        LinkedList<Appointment> appointmentList = new LinkedList<Appointment>();
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator<Appointment> searchIterator = null;
        try {
            AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
            CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
            searchIterator = appointmentsql.getAppointmentsByExtendedSearch(searchObj, orderBy, orderDir, _appointmentFields);
            AppointmentWriter appointmentwriter = new AppointmentWriter(timeZone).setSession(this.session);
            while (searchIterator.hasNext()) {
                Appointment appointmentobject = (Appointment)searchIterator.next();
                boolean processed = false;
                if (appointmentobject.getRecurrenceType() != 0 && appointmentobject.getRecurrencePosition() == 0) {
                    RecurringResultsInterface recuResults = null;
                    try {
                        recuResults = recColl.calculateRecurring(appointmentobject, start.getTime(), end.getTime(), 0);
                        processed = true;
                    }
                    catch (OXException x) {
                        LOG.error("Can not calculate recurrence {}:{}", new Object[]{appointmentobject.getObjectID(), this.ctx.getContextId(), x});
                    }
                    if (recuResults != null && recuResults.size() > 0) {
                        RecurringResultInterface result = recuResults.getRecurringResult(0);
                        appointmentobject.setStartDate(new Date(result.getStart()));
                        appointmentobject.setEndDate(new Date(result.getEnd()));
                        appointmentobject.setRecurrencePosition(result.getPosition());
                        if (appointmentobject.getFullTime()) {
                            if (recColl.inBetween(appointmentobject.getStartDate().getTime(), appointmentobject.getEndDate().getTime(), startUTC.getTime(), endUTC.getTime())) {
                                this.compareStartDateForList(appointmentList, appointmentobject, limit);
                            }
                        } else {
                            this.compareStartDateForList(appointmentList, appointmentobject, limit);
                        }
                    }
                }
                if (!processed) {
                    if (appointmentobject.getFullTime() && startUTC != null && endUTC != null) {
                        if (recColl.inBetween(appointmentobject.getStartDate().getTime(), appointmentobject.getEndDate().getTime(), startUTC.getTime(), endUTC.getTime())) {
                            this.compareStartDateForList(appointmentList, appointmentobject, limit);
                        }
                    } else {
                        this.compareStartDateForList(appointmentList, appointmentobject, limit);
                    }
                }
                if (!this.timestamp.before(appointmentobject.getLastModified())) continue;
                this.timestamp = appointmentobject.getLastModified();
            }
            for (int a = 0; a < appointmentList.size(); ++a) {
                Appointment appointmentObj = (Appointment)appointmentList.get(a);
                if (appointmentObj.getFullTime()) {
                    appointmentwriter.writeArray(appointmentObj, columns, startUTC, endUTC, jsonResponseArray);
                    continue;
                }
                appointmentwriter.writeArray(appointmentObj, columns, jsonResponseArray);
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            if (searchIterator != null) {
                searchIterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionFreeBusy(JSONObject jsonObj) throws JSONException, OXException {
        int userId = DataParser.checkInt(jsonObj, "id");
        int type = DataParser.checkInt(jsonObj, "type");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        Date start = DataParser.checkTime(jsonObj, "start", timeZone);
        Date end = DataParser.checkTime(jsonObj, "end", timeZone);
        this.timestamp = new Date(0L);
        SearchIterator<Appointment> it = null;
        JSONArray jsonResponseArray = new JSONArray();
        try {
            AppointmentWriter appointmentWriter = new AppointmentWriter(timeZone).setSession(this.session);
            AppointmentSQLInterface appointmentsql = this.appointmentFactory.createAppointmentSql(this.session);
            it = appointmentsql.getFreeBusyInformation(userId, type, start, end);
            while (it.hasNext()) {
                Appointment appointmentObj = (Appointment)it.next();
                JSONObject jsonAppointmentObj = new JSONObject();
                appointmentWriter.writeAppointment(appointmentObj, jsonAppointmentObj);
                jsonResponseArray.put((Object)jsonAppointmentObj);
                if (null == appointmentObj.getLastModified() || !this.timestamp.before(appointmentObj.getLastModified())) continue;
                this.timestamp = appointmentObj.getLastModified();
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONObject actionCopy(JSONObject jsonObj) throws JSONException, OXException {
        int id = DataParser.checkInt(jsonObj, "id");
        int inFolder = DataParser.checkInt(jsonObj, "folder");
        boolean ignoreConflicts = DataParser.checkBoolean(jsonObj, "ignore_conflicts");
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        int folderId = DataParser.checkInt(jData, "folder_id");
        String timeZoneId = DataParser.parseString(jsonObj, "timezone");
        TimeZone timeZone = null == timeZoneId ? this.timeZone : TimeZoneUtils.getTimeZone(timeZoneId);
        AppointmentSQLInterface appointmentSql = this.appointmentFactory.createAppointmentSql(this.session);
        this.timestamp = new Date(0L);
        CalendarDataObject appointmentObj = null;
        try {
            appointmentObj = appointmentSql.getObjectById(id, inFolder);
        }
        catch (SQLException exc) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(exc, new Object[0]);
        }
        appointmentObj.removeObjectID();
        appointmentObj.removeUid();
        appointmentObj.setParentFolderID(folderId);
        appointmentObj.setIgnoreConflicts(ignoreConflicts);
        Appointment[] conflicts = appointmentSql.insertAppointmentObject(appointmentObj);
        JSONObject jsonResponseObj = new JSONObject();
        if (conflicts != null) {
            JSONArray jsonConflictArray = new JSONArray(conflicts.length);
            AppointmentWriter appointmentWriter = new AppointmentWriter(timeZone).setSession(this.session);
            for (int a = 0; a < conflicts.length; ++a) {
                JSONObject jsonAppointmentObj = new JSONObject();
                appointmentWriter.writeAppointment(conflicts[a], jsonAppointmentObj);
                jsonConflictArray.put((Object)jsonAppointmentObj);
            }
        } else {
            jsonResponseObj.put("id", appointmentObj.getObjectID());
            this.timestamp = appointmentObj.getLastModified();
        }
        return jsonResponseObj;
    }

    private boolean shouldAnonymize(Appointment cdao, int uid) {
        if (!cdao.getPrivateFlag()) {
            return false;
        }
        if (cdao.getCreatedBy() == uid) {
            return false;
        }
        for (UserParticipant user : cdao.getUsers()) {
            if (user.getIdentifier() != uid) continue;
            return false;
        }
        return true;
    }

    private void compareStartDateForList(LinkedList<Appointment> appointmentList, Appointment appointmentObj, int limit) {
        if (limit > 0) {
            boolean found = false;
            for (int a = 0; a < appointmentList.size(); ++a) {
                Appointment compareAppointment = appointmentList.get(a);
                if (appointmentObj.getStartDate().getTime() >= compareAppointment.getStartDate().getTime()) continue;
                appointmentList.add(a, appointmentObj);
                found = true;
                break;
            }
            if (!found) {
                appointmentList.addLast(appointmentObj);
            }
            if (appointmentList.size() > limit) {
                appointmentList.removeLast();
            }
        } else {
            appointmentList.add(appointmentObj);
        }
    }

    private Date getDateByFieldId(int field, Appointment appointmentObj, TimeZone timeZone) {
        Date date = null;
        if (field == 201) {
            return appointmentObj.getStartDate();
        }
        if (field == 202) {
            return appointmentObj.getEndDate();
        }
        if (date == null) {
            return null;
        }
        if (appointmentObj.getFullTime()) {
            return date;
        }
        int offset = timeZone.getOffset(date.getTime());
        return new Date(date.getTime() + (long)offset);
    }

    private Date applyTimeZone2Date(long utcTime) {
        return new Date(utcTime - (long)this.timeZone.getOffset(utcTime));
    }

    private void anonymize(Appointment anonymized) {
        anonymized.setTitle("Private");
        anonymized.removeAlarm();
        anonymized.removeCategories();
        anonymized.removeConfirm();
        anonymized.removeConfirmMessage();
        anonymized.removeLabel();
        anonymized.removeLocation();
        anonymized.removeNote();
        anonymized.removeNotification();
        anonymized.removeParticipants();
        anonymized.removeShownAs();
        anonymized.removeUsers();
    }
}

