/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.osgi;

import com.openexchange.osgi.HousekeepingActivator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServletActivator
extends HousekeepingActivator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServletActivator.class);
    private final List<String> servlets = new ArrayList<String>();

    protected void registerServlet(String alias, HttpServlet servlet, HttpService httpService) {
        this.registerServlet(alias, servlet, null, httpService);
    }

    protected void registerServlet(String alias, HttpServlet servlet, Dictionary<String, String> params, HttpService httpService) {
        try {
            httpService.registerServlet(alias, (Servlet)servlet, params, null);
            this.servlets.add(alias);
        }
        catch (ServletException e) {
            LOG.error("", (Throwable)e);
        }
        catch (NamespaceException e) {
            LOG.error("", (Throwable)e);
        }
    }

    protected void cleanUp() {
        this.unregisterServlets();
        super.cleanUp();
    }

    private void unregisterServlets() {
        HttpService httpService = (HttpService)this.getService(HttpService.class);
        if (null != httpService) {
            for (String servlet : this.servlets) {
                try {
                    httpService.unregister(servlet);
                }
                catch (Exception e) {
                    LOG.warn("Failed to unregister servlet alias: {}", (Object)servlet, (Object)e);
                }
            }
        }
    }

    protected void unregisterServlet(String alias) {
        HttpService httpService = (HttpService)this.getService(HttpService.class);
        if (null != httpService) {
            httpService.unregister(alias);
        }
        this.servlets.remove(alias);
    }
}

