/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.login.AbstractLoginRequestHandler;
import com.openexchange.ajax.login.LoginClosure;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.oauth.provider.OAuthProviderService;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;

public class OAuthLogin
extends AbstractLoginRequestHandler {
    private final LoginConfiguration conf;

    public OAuthLogin(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doOAuthLogin(req, resp);
        }
        catch (OXException e) {
            LoginServlet.logAndSendException(resp, e);
        }
    }

    private void doOAuthLogin(HttpServletRequest req, final HttpServletResponse resp) throws IOException, OXException {
        this.loginOperation(req, resp, new LoginClosure(){

            @Override
            public LoginResult doLogin(HttpServletRequest req2) throws OXException {
                try {
                    OAuthProviderService providerService = ServerServiceRegistry.getInstance().getService(OAuthProviderService.class);
                    OAuthMessage requestMessage = OAuthServlet.getMessage((HttpServletRequest)req2, null);
                    OAuthAccessor accessor = providerService.getAccessor(requestMessage);
                    providerService.getValidator().validateMessage(requestMessage, accessor);
                    String login = (String)accessor.getProperty("login");
                    String password = (String)accessor.getProperty("password");
                    LoginRequestImpl request = LoginTools.parseLogin(req2, login, password, false, OAuthLogin.this.conf.getDefaultClient(), OAuthLogin.this.conf.isCookieForceHTTPS(), false);
                    return LoginPerformer.getInstance().doLogin(request);
                }
                catch (OAuthProblemException e) {
                    try {
                        this.handleException((Exception)((Object)e), req2, resp, false);
                        return null;
                    }
                    catch (IOException ioe) {
                        throw LoginExceptionCodes.UNKNOWN.create((Throwable)ioe, new Object[]{ioe.getMessage()});
                    }
                    catch (ServletException se) {
                        throw LoginExceptionCodes.UNKNOWN.create((Throwable)se, new Object[]{se.getMessage()});
                    }
                }
                catch (IOException e) {
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (OAuthException e) {
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (URISyntaxException e) {
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }

            private void handleException(Exception e, HttpServletRequest request, HttpServletResponse response, boolean sendBody) throws IOException, ServletException {
                StringAllocator realm = new StringAllocator(32).append(request.isSecure() ? "https://" : "http://");
                realm.append(request.getLocalName());
                OAuthServlet.handleException((HttpServletResponse)response, (Exception)e, (String)realm.toString(), (boolean)sendBody);
            }
        }, this.conf);
    }
}

