/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.login.AbstractLoginRequestHandler;
import com.openexchange.ajax.login.LoginClosure;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.exception.OXException;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Login
extends AbstractLoginRequestHandler {
    private final LoginConfiguration conf;

    public Login(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doLogin(req, resp);
        }
        catch (OXException e) {
            LoginServlet.logAndSendException(resp, e);
        }
    }

    private void doLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException, OXException {
        this.loginOperation(req, resp, new LoginClosure(){

            @Override
            public LoginResult doLogin(HttpServletRequest req2) throws OXException {
                LoginRequestImpl request = LoginTools.parseLogin(req2, "name", false, Login.this.conf.getDefaultClient(), Login.this.conf.isCookieForceHTTPS(), Login.this.conf.isDisableTrimLogin(), false);
                return LoginPerformer.getInstance().doLogin(request);
            }
        }, this.conf);
    }
}

