/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.container.ByteArrayInputStreamClosure;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;

public class FileHolder
implements IFileHolder {
    private static final Field bufField;
    private static final Field markField;
    private IFileHolder.InputStreamClosure isClosure;
    private InputStream is;
    private long length;
    private String contentType;
    private String name;
    private String disposition;
    private String delivery;

    private static byte[] bytesFrom(ByteArrayInputStream bais) {
        if (null == bais) {
            return null;
        }
        try {
            Field bufField = FileHolder.bufField;
            Field markfield = markField;
            if (null != bufField && null != markfield) {
                byte[] buf = (byte[])bufField.get(bais);
                int mark = markfield.getInt(bais);
                if (mark <= 0) {
                    return buf;
                }
                int len = buf.length - mark;
                if (len <= 0) {
                    return null;
                }
                byte[] ret = new byte[len];
                System.arraycopy(buf, mark, ret, 0, len);
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static IFileHolder.InputStreamClosure newClosureFor(File file) {
        return null == file ? null : new FileInputStreamClosure(file);
    }

    public FileHolder(InputStream is, long length, String contentType, String name) {
        this.is = is;
        this.length = length;
        this.contentType = contentType;
        this.name = name;
    }

    public FileHolder(IFileHolder.InputStreamClosure isClosure, long length, String contentType, String name) {
        this.isClosure = isClosure;
        this.length = length;
        this.contentType = contentType;
        this.name = name;
    }

    public FileHolder(final File file, String contentType) {
        this.length = file.length();
        this.contentType = contentType == null ? MimeType2ExtMap.getContentType(file) : contentType;
        this.name = file.getName();
        this.isClosure = new IFileHolder.InputStreamClosure(){

            @Override
            public InputStream newStream() throws OXException, IOException {
                return new FileInputStream(file);
            }
        };
    }

    public FileHolder(File file) {
        this(file, null);
    }

    @Override
    public boolean repetitive() {
        ByteArrayInputStream bais;
        byte[] bytes;
        if (null != this.isClosure) {
            return true;
        }
        if (this.is instanceof ByteArrayInputStream && null != (bytes = FileHolder.bytesFrom(bais = (ByteArrayInputStream)this.is))) {
            this.isClosure = new ByteArrayInputStreamClosure(bytes);
            this.is = null;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public InputStream getStream() throws OXException {
        IFileHolder.InputStreamClosure isClosure = this.isClosure;
        if (null != isClosure) {
            try {
                return isClosure.newStream();
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
        return this.is;
    }

    public void setStream(InputStream is) {
        Streams.close((Closeable)this.is);
        this.is = is;
        this.isClosure = null;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    @Override
    public String getDelivery() {
        return this.delivery;
    }

    static {
        Field f;
        try {
            f = ByteArrayInputStream.class.getDeclaredField("buf");
            f.setAccessible(true);
        }
        catch (SecurityException e) {
            f = null;
        }
        catch (NoSuchFieldException e) {
            f = null;
        }
        bufField = f;
        try {
            f = ByteArrayInputStream.class.getDeclaredField("mark");
            f.setAccessible(true);
        }
        catch (SecurityException e) {
            f = null;
        }
        catch (NoSuchFieldException e) {
            f = null;
        }
        markField = f;
    }

    private static final class FileInputStreamClosure
    implements IFileHolder.InputStreamClosure {
        private final File file;

        FileInputStreamClosure(File file) {
            this.file = file;
        }

        @Override
        public InputStream newStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }
}

