/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.DataServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.request.TaskRequest;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tasks
extends DataServlet {
    private static final long serialVersionUID = 8092832647688901704L;
    private static final Logger LOG = LoggerFactory.getLogger(Tasks.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ServerSession session = Tasks.getSessionObject((ServletRequest)httpServletRequest);
        Response response = new Response(session);
        try {
            JSONObject jsonObj;
            String action = Tasks.parseMandatoryStringParameter(httpServletRequest, "action");
            try {
                jsonObj = Tasks.convertParameter2JSONObject(httpServletRequest);
            }
            catch (JSONException e) {
                LOG.error("", (Throwable)e);
                response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                this.writeResponse(response, httpServletResponse, session);
                return;
            }
            TaskRequest taskRequest = new TaskRequest(session);
            JSONValue responseObj = taskRequest.action(action, jsonObj);
            response.setTimestamp(taskRequest.getTimestamp());
            response.setData(responseObj);
        }
        catch (OXException e) {
            if (e.getCategory() == Category.CATEGORY_USER_INPUT) {
                LOG.debug("", (Throwable)e);
            } else {
                LOG.error("", (Throwable)e);
            }
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error("", (Throwable)oje);
            response.setException(oje);
        }
        this.writeResponse(response, httpServletResponse, session);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Response response;
        ServerSession session;
        block12: {
            session = Tasks.getSessionObject((ServletRequest)httpServletRequest);
            response = new Response(session);
            try {
                String action = Tasks.parseMandatoryStringParameter(httpServletRequest, "action");
                String data = Tasks.getBody(httpServletRequest);
                if (data.length() > 0) {
                    JSONObject jsonObj;
                    TaskRequest taskRequest = new TaskRequest(session);
                    try {
                        jsonObj = Tasks.convertParameter2JSONObject(httpServletRequest);
                    }
                    catch (JSONException e) {
                        LOG.error("", (Throwable)e);
                        response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                        this.writeResponse(response, httpServletResponse, session);
                        return;
                    }
                    if (data.charAt(0) == '[') {
                        JSONArray jsonDataArray = new JSONArray(data);
                        jsonObj.put("data", (Object)jsonDataArray);
                        JSONValue responseObj = taskRequest.action(action, jsonObj);
                        response.setTimestamp(taskRequest.getTimestamp());
                        response.setData(responseObj);
                    } else if (data.charAt(0) == '{') {
                        JSONObject jsonDataObject = new JSONObject(data);
                        jsonObj.put("data", (Object)jsonDataObject);
                        JSONValue responseObj = taskRequest.action(action, jsonObj);
                        response.setTimestamp(taskRequest.getTimestamp());
                        response.setData(responseObj);
                    } else {
                        httpServletResponse.sendError(400, "invalid json object");
                    }
                    break block12;
                }
                httpServletResponse.sendError(400, "no data found");
            }
            catch (JSONException e) {
                OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                LOG.error("", (Throwable)oje);
                response.setException(oje);
            }
            catch (OXException e) {
                if (e.getCategory() == Category.CATEGORY_USER_INPUT) {
                    LOG.debug("", (Throwable)e);
                } else {
                    LOG.error("", (Throwable)e);
                }
                response.setException(e);
            }
        }
        this.writeResponse(response, httpServletResponse, session);
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return session.getUserPermissionBits().hasTask();
    }
}

