/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.configjump.ICookie;
import com.openexchange.configjump.Replacements;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigJump
extends SessionServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigJump.class);
    private static final long serialVersionUID = -6938253595032363499L;

    protected void doGet(final HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        final ServerSession sessionObj = ConfigJump.getSessionObject((ServletRequest)req);
        Response response = new Response(sessionObj);
        try {
            final Context ctx = ContextStorage.getInstance().getContext(sessionObj.getContextId());
            final String protocol = Tools.getProtocol(req);
            URL url = com.openexchange.configjump.client.ConfigJump.getLink(new Replacements(){

                public int getContextId() {
                    return sessionObj.getContextId();
                }

                public String getPassword() {
                    return sessionObj.getPassword();
                }

                public String getUsername() {
                    return sessionObj.getUserlogin();
                }

                public String getProtocol() {
                    return protocol;
                }

                public String getServerName() {
                    return req.getServerName();
                }

                public int getServerPort() {
                    return req.getServerPort();
                }

                public ICookie[] getCookies() {
                    Cookie[] cookies = req.getCookies();
                    ICookie[] retval = new ICookie[cookies.length];
                    for (int i = 0; i < cookies.length; ++i) {
                        retval[i] = new CookieImpl(cookies[i].getName(), cookies[i].getValue());
                    }
                    return retval;
                }

                public String[] getContextInfos() {
                    return ctx.getLoginInfo();
                }
            });
            response.setData(url);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            response.setException(e);
        }
        resp.setContentType("text/javascript; charset=UTF-8");
        try {
            ResponseWriter.write(response, resp.getWriter(), ConfigJump.localeFrom(sessionObj));
        }
        catch (JSONException e) {
            this.log("Error while writing response object.", e);
            ConfigJump.sendError(resp);
        }
    }

    private static class CookieImpl
    implements ICookie {
        private final String name;
        private final String value;

        public CookieImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

