/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.console.osgi;

import com.openexchange.osgi.console.ServiceStateCommandProvider;
import com.openexchange.osgi.console.ServiceStateLookup;
import java.util.regex.Pattern;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ConsoleActivator
implements BundleActivator,
CommandProvider {
    private ServiceTracker<ServiceStateLookup, ServiceStateLookup> tracker;
    private volatile BundleContext context;
    protected volatile ServiceRegistration<CommandProvider> registration;
    private volatile ServiceRegistration<CommandProvider> thisRegistration;

    public void start(final BundleContext context) throws Exception {
        this.context = context;
        this.tracker = new ServiceTracker(context, ServiceStateLookup.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServiceStateLookup, ServiceStateLookup>(){

            public ServiceStateLookup addingService(ServiceReference<ServiceStateLookup> reference) {
                ServiceStateLookup lookup = (ServiceStateLookup)context.getService(reference);
                ConsoleActivator.this.registration = context.registerService(CommandProvider.class, (Object)new ServiceStateCommandProvider(lookup), null);
                return lookup;
            }

            public void modifiedService(ServiceReference<ServiceStateLookup> reference, ServiceStateLookup service) {
            }

            public void removedService(ServiceReference<ServiceStateLookup> reference, ServiceStateLookup service) {
                context.ungetService(reference);
                ConsoleActivator.this.registration.unregister();
            }
        });
        this.tracker.open();
        this.thisRegistration = context.registerService(CommandProvider.class, (Object)this, null);
    }

    public void stop(BundleContext context) throws Exception {
        ServiceRegistration<CommandProvider> thisRegistration;
        this.context = null;
        if (null != this.tracker) {
            this.tracker.close();
            this.tracker = null;
        }
        if (null != (thisRegistration = this.thisRegistration)) {
            thisRegistration.unregister();
            this.thisRegistration = null;
        }
    }

    public String getHelp() {
        return "\tuname - returns framework information\n\tfind <wild-card-expression> - looks-up services matching given search expression\n";
    }

    public void _uname(CommandInterpreter ci) {
        BundleContext context = this.context;
        String vendor = context.getProperty("org.osgi.framework.vendor");
        String version = context.getProperty("org.osgi.framework.version");
        String osName = context.getProperty("org.osgi.framework.os.name");
        String osVersion = context.getProperty("org.osgi.framework.os.version");
        ci.println((Object)("\n " + vendor + " " + version + " (" + osName + " " + osVersion + ")"));
    }

    public void _find(CommandInterpreter ci) throws Exception {
        BundleContext context = this.context;
        ServiceReference[] references = context.getAllServiceReferences(null, null);
        String filter = ci.nextArgument();
        if (null == filter) {
            ci.println((Object)"Missing argument for 'find'; e.g. \"find *MyService\"");
        } else {
            Pattern pattern = Pattern.compile(ConsoleActivator.wildcardToRegex(filter), 2);
            for (ServiceReference serviceReference : references) {
                String className = context.getService(serviceReference).getClass().getName();
                if (pattern.matcher(className).matches()) {
                    ci.println((Object)className);
                }
                context.ungetService(serviceReference);
            }
        }
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }
}

