/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.java.StringAllocator;
import java.util.Collection;
import java.util.Stack;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class Tools {
    public static final Filter generateServiceFilter(BundleContext context, Class<?> ... classes) throws InvalidSyntaxException {
        if (classes.length < 2) {
            throw new IllegalArgumentException("At least the classes of 2 services must be given.");
        }
        StringAllocator sb = new StringAllocator("(|(");
        for (Class<?> clazz : classes) {
            sb.append("objectClass");
            sb.append('=');
            sb.append(clazz.getName());
            sb.append(")(");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return context.createFilter(sb.toString());
    }

    public static final void open(Collection<ServiceTracker<?, ?>> trackers) {
        for (ServiceTracker<?, ?> tracker : trackers) {
            tracker.open();
        }
    }

    public static final void close(Stack<ServiceTracker<?, ?>> trackers) {
        while (!trackers.isEmpty()) {
            trackers.pop().close();
        }
    }

    private Tools() {
    }
}

