/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionUtils.class);

    public static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            LOG.error(ExceptionUtils.surroundWithMarker("Thread death"), t);
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            String message = "The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.";
            LOG.error(ExceptionUtils.surroundWithMarker("The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating."), t);
            throw (VirtualMachineError)t;
        }
    }

    private static String surroundWithMarker(String message) {
        String marker = " ---=== /!\\ ===--- ";
        return new StringBuilder(message.length() + 40).append(" ---=== /!\\ ===--- ").append(message).append(" ---=== /!\\ ===--- ").toString();
    }
}

