/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.Tools;
import com.openexchange.osgi.console.ServiceStateLookup;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependantServiceRegisterer<S>
implements ServiceTrackerCustomizer<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(DependantServiceRegisterer.class);
    private final Lock lock = new ReentrantLock();
    private final BundleContext context;
    private final Class<S> serviceType;
    private final Class<? extends S> serviceClass;
    private final Dictionary<String, ?> properties;
    private final Class<?>[] neededServices;
    private final Object[] foundServices;
    private S registeredService;
    private ServiceRegistration<?> registration;

    public DependantServiceRegisterer(BundleContext context, Class<S> serviceType, Class<? extends S> serviceClass, Dictionary<String, ?> properties, Class<?> ... neededServices) {
        this.context = context;
        this.serviceType = serviceType;
        this.serviceClass = serviceClass;
        this.properties = properties;
        this.neededServices = neededServices;
        this.foundServices = new Object[neededServices.length];
        this.setState();
    }

    public Filter getFilter() throws InvalidSyntaxException {
        return Tools.generateServiceFilter(this.context, this.neededServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference<Object> reference) {
        boolean bl;
        Object obj = this.context.getService(reference);
        boolean needsRegistration = true;
        this.lock.lock();
        try {
            for (int i = 0; i < this.neededServices.length; ++i) {
                if (this.neededServices[i].isAssignableFrom(obj.getClass())) {
                    this.foundServices[i] = obj;
                }
                needsRegistration &= null != this.foundServices[i];
            }
            bl = null == this.registration;
        }
        finally {
            this.lock.unlock();
        }
        if (needsRegistration &= bl) {
            try {
                Constructor<S> constructor = this.serviceClass.getConstructor(this.neededServices);
                this.registeredService = constructor.newInstance(this.foundServices);
                LOG.trace("Registering service {}", (Object)this.serviceClass.getName());
                this.registration = this.context.registerService(this.serviceType, this.registeredService, this.properties);
            }
            catch (Throwable t) {
                LOG.error("Can not register {}", (Object)this.serviceClass.getName(), (Object)t);
            }
        }
        this.setState();
        return obj;
    }

    public void modifiedService(ServiceReference<Object> arg0, Object arg1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<Object> reference, Object service) {
        ServiceRegistration<?> unregister = null;
        this.lock.lock();
        try {
            boolean someServiceMissing = false;
            for (int i = 0; i < this.neededServices.length; ++i) {
                if (this.neededServices[i].isAssignableFrom(service.getClass())) {
                    this.foundServices[i] = null;
                }
                someServiceMissing |= null == this.foundServices[i];
            }
            if (null != this.registration && someServiceMissing) {
                unregister = this.registration;
                this.registration = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (null != unregister) {
            LOG.trace("Unregistering service {}", (Object)this.serviceClass.getName());
            unregister.unregister();
            try {
                Method method = this.serviceClass.getMethod("shutDown", new Class[0]);
                method.invoke(this.registeredService, new Object[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (Throwable t) {
                LOG.error("Can not shut down {}", (Object)this.serviceClass.getName(), (Object)t);
            }
        }
        this.setState();
        this.context.ungetService(reference);
    }

    private void setState() {
        ServiceStateLookup lookup = DeferredActivator.getLookup();
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> present = new ArrayList<String>();
        for (int i = 0; i < this.neededServices.length; ++i) {
            String serviceName = this.neededServices[i].getName();
            if (null == this.foundServices[i]) {
                missing.add(serviceName);
                continue;
            }
            present.add(serviceName);
        }
        lookup.setState(this.serviceClass.getName(), missing, present);
    }
}

