/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.AbstractStringAllocator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public final class StringAllocator
extends AbstractStringAllocator
implements Serializable {
    private static final long serialVersionUID = -7570175078892044337L;
    private static final Constructor<String> STRING_CONSTRUCTOR;

    public StringAllocator() {
        super(16);
    }

    public StringAllocator(int capacity) {
        super(capacity);
    }

    public StringAllocator(String str) {
        this(null == str ? "null" : str, 16);
    }

    private StringAllocator(String str, int off) {
        super(str.length() + off);
        this.append(str);
    }

    public StringAllocator(CharSequence seq) {
        this(seq.length() + 16);
        this.append(seq);
    }

    @Override
    public StringAllocator append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    @Override
    public StringAllocator append(String str) {
        super.append(str);
        return this;
    }

    private StringAllocator append(StringAllocator sb) {
        if (sb == null) {
            return this.append("null");
        }
        int len = sb.length();
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    @Override
    public StringAllocator append(StringBuffer sb) {
        super.append(sb);
        return this;
    }

    @Override
    public StringAllocator append(CharSequence s) {
        if (s == null) {
            return this.append("null");
        }
        if (s instanceof String) {
            return this.append((String)s);
        }
        if (s instanceof StringBuffer) {
            return this.append((StringBuffer)s);
        }
        if (s instanceof StringAllocator) {
            return this.append((StringAllocator)s);
        }
        return this.append(s, 0, s.length());
    }

    @Override
    public StringAllocator append(CharSequence s, int start, int end) {
        super.append(s, start, end);
        return this;
    }

    @Override
    public StringAllocator append(char[] str) {
        super.append(str);
        return this;
    }

    @Override
    public StringAllocator append(char[] str, int offset, int len) {
        super.append(str, offset, len);
        return this;
    }

    @Override
    public StringAllocator append(boolean b) {
        super.append(b);
        return this;
    }

    @Override
    public StringAllocator append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public StringAllocator append(int i) {
        super.append(i);
        return this;
    }

    @Override
    public StringAllocator append(long lng) {
        super.append(lng);
        return this;
    }

    @Override
    public StringAllocator append(float f) {
        super.append(f);
        return this;
    }

    @Override
    public StringAllocator append(double d) {
        super.append(d);
        return this;
    }

    @Override
    public StringAllocator appendCodePoint(int codePoint) {
        super.appendCodePoint(codePoint);
        return this;
    }

    @Override
    public StringAllocator delete(int start, int end) {
        super.delete(start, end);
        return this;
    }

    @Override
    public StringAllocator deleteCharAt(int index) {
        super.deleteCharAt(index);
        return this;
    }

    @Override
    public StringAllocator deleteLastChar() {
        super.deleteLastChar();
        return this;
    }

    @Override
    public StringAllocator replace(int start, int end, String str) {
        super.replace(start, end, str);
        return this;
    }

    @Override
    public StringAllocator insert(int index, char[] str, int offset, int len) {
        super.insert(index, str, offset, len);
        return this;
    }

    @Override
    public StringAllocator insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    @Override
    public StringAllocator insert(int offset, String str) {
        super.insert(offset, str);
        return this;
    }

    @Override
    public StringAllocator insert(int offset, char[] str) {
        super.insert(offset, str);
        return this;
    }

    @Override
    public StringAllocator insert(int dstOffset, CharSequence s) {
        if (s == null) {
            return this.insert(dstOffset, "null");
        }
        if (s instanceof String) {
            return this.insert(dstOffset, (String)s);
        }
        return this.insert(dstOffset, s, 0, s.length());
    }

    @Override
    public StringAllocator insert(int dstOffset, CharSequence s, int start, int end) {
        super.insert(dstOffset, s, start, end);
        return this;
    }

    @Override
    public StringAllocator insert(int offset, boolean b) {
        super.insert(offset, b);
        return this;
    }

    @Override
    public StringAllocator insert(int offset, char c) {
        super.insert(offset, c);
        return this;
    }

    @Override
    public StringAllocator insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    @Override
    public StringAllocator insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    @Override
    public StringAllocator insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    @Override
    public StringAllocator insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    @Override
    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    @Override
    public int indexOf(String str, int fromIndex) {
        return AbstractStringAllocator.indexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    @Override
    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    @Override
    public int lastIndexOf(String str, int fromIndex) {
        return AbstractStringAllocator.lastIndexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    @Override
    public StringAllocator reverse() {
        super.reverse();
        return this;
    }

    @Override
    public String substring(int start) {
        return this.substring(start, this.count);
    }

    @Override
    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        Constructor<String> stringConstructor = STRING_CONSTRUCTOR;
        if (null == stringConstructor) {
            return new String(this.value, start, end - start);
        }
        try {
            return stringConstructor.newInstance(start, end - start, this.value);
        }
        catch (Exception e) {
            return new String(this.value, start, end - start);
        }
    }

    @Override
    public String toString() {
        if (0 == this.count) {
            return "";
        }
        Constructor<String> stringConstructor = STRING_CONSTRUCTOR;
        if (null == stringConstructor) {
            return new String(this.value, 0, this.count);
        }
        try {
            return stringConstructor.newInstance(0, this.count, this.value);
        }
        catch (Exception e) {
            return new String(this.value, 0, this.count);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.count);
        s.writeObject(this.value);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.count = s.readInt();
        this.value = (char[])s.readObject();
    }

    static {
        Constructor strConstructor;
        try {
            strConstructor = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
            strConstructor.setAccessible(true);
        }
        catch (SecurityException e) {
            strConstructor = null;
        }
        catch (NoSuchMethodException e) {
            strConstructor = null;
        }
        STRING_CONSTRUCTOR = strConstructor;
    }
}

