/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class LimitedExecutorService
implements ExecutorService {
    private final ExecutorService executor;
    private final ScheduledLock scheduledLock;

    public LimitedExecutorService(ExecutorService executor, int concurrencyLimit) {
        if (concurrencyLimit <= 0) {
            throw new IllegalArgumentException("concurrencyLimit is less than or equal to zero.");
        }
        this.executor = executor;
        this.scheduledLock = new ScheduledLock(concurrencyLimit, new ConcurrentLinkedQueue<Runnable>());
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException("Runnable is null");
        }
        if (this.scheduledLock.incrementFor(command)) {
            this.executor.execute(new ReschedulingRunnable(command, this.scheduledLock));
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(tasks, timeout, unit);
    }

    private static final class ReschedulingRunnable
    implements Runnable {
        private final Runnable firstTask;
        private final ScheduledLock scheduledLock;

        ReschedulingRunnable(Runnable firstTask, ScheduledLock scheduledLock) {
            this.firstTask = firstTask;
            this.scheduledLock = scheduledLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable next = this.firstTask;
            while (null != next) {
                try {
                    next.run();
                }
                finally {
                    next = this.scheduledLock.decrementIfNoneInQueue();
                }
            }
        }
    }

    private static final class ScheduledLock {
        private int count;
        private final Lock lock;
        private final int max;
        private final Queue<Runnable> workQueue;

        ScheduledLock(int max, Queue<Runnable> workQueue) {
            this.workQueue = workQueue;
            this.max = max;
            this.lock = new ReentrantLock();
            this.count = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean incrementFor(Runnable command) {
            this.lock.lock();
            try {
                if (this.count < this.max) {
                    ++this.count;
                    boolean bl = true;
                    return bl;
                }
                this.workQueue.offer(command);
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Runnable decrementIfNoneInQueue() {
            Runnable fromQueue = this.workQueue.poll();
            if (null != fromQueue) {
                return fromQueue;
            }
            this.lock.lock();
            try {
                fromQueue = this.workQueue.poll();
                if (null != fromQueue) {
                    Runnable runnable = fromQueue;
                    return runnable;
                }
                if (this.count > 1) {
                    --this.count;
                }
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }
    }
}

