/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentSortedSet<E>
implements SortedSet<E> {
    private final AtomicReference<SortedSet<E>> ref;

    public ConcurrentSortedSet() {
        this.ref = new AtomicReference(new TreeSet());
    }

    public ConcurrentSortedSet(Collection<? extends E> c) {
        this.ref = new AtomicReference<TreeSet<E>>(new TreeSet<E>(c));
    }

    public SortedSet<E> getSnapshot() {
        return Collections.unmodifiableSortedSet(this.ref.get());
    }

    @Override
    public int size() {
        return this.ref.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.ref.get().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.ref.get().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.ref.get().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.ref.get().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.ref.get().toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean added;
        TreeSet<E> set;
        SortedSet<E> expected;
        do {
            expected = this.ref.get();
            set = new TreeSet<E>(expected);
            added = set.add(e);
        } while (!this.ref.compareAndSet(expected, set));
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed;
        TreeSet<E> set;
        SortedSet<E> expected;
        do {
            expected = this.ref.get();
            set = new TreeSet<E>(expected);
            removed = set.remove(o);
        } while (!this.ref.compareAndSet(expected, set));
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.ref.get().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added;
        TreeSet<? extends E> set;
        SortedSet<E> expected;
        do {
            expected = this.ref.get();
            set = new TreeSet<E>(expected);
            added = set.addAll(c);
        } while (!this.ref.compareAndSet(expected, set));
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret;
        TreeSet<E> set;
        SortedSet<E> expected;
        do {
            expected = this.ref.get();
            set = new TreeSet<E>(expected);
            ret = set.retainAll(c);
        } while (!this.ref.compareAndSet(expected, set));
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret;
        TreeSet<E> set;
        SortedSet<E> expected;
        do {
            expected = this.ref.get();
            set = new TreeSet<E>(expected);
            ret = set.removeAll(c);
        } while (!this.ref.compareAndSet(expected, set));
        return ret;
    }

    @Override
    public void clear() {
        TreeSet set;
        SortedSet<E> expected;
        while (!this.ref.compareAndSet(expected = this.ref.get(), set = new TreeSet())) {
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.ref.get().comparator();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.ref.get().subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.ref.get().headSet(toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.ref.get().tailSet(fromElement);
    }

    @Override
    public E first() {
        return this.ref.get().first();
    }

    @Override
    public E last() {
        return this.ref.get().last();
    }
}

