/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import java.util.Arrays;
import java.util.Comparator;
import org.slf4j.Logger;

public enum LogLevel {
    TRACE,
    DEBUG,
    INFO,
    WARNING,
    ERROR;

    public static final Comparator<LogLevel> COMPARATOR;

    public boolean isDebug() {
        return DEBUG.equals((Object)this);
    }

    public boolean implies(Category category) {
        return this.implies(category.getLogLevel());
    }

    public boolean implies(LogLevel logLevel) {
        return this.ordinal() <= logLevel.ordinal();
    }

    public boolean appliesTo(Logger logger) {
        switch (this) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARNING: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        return false;
    }

    public void log(String logging, OXException exception, Logger logger) {
        switch (this) {
            case TRACE: {
                logger.trace(logging, (Throwable)exception);
                break;
            }
            case DEBUG: {
                logger.debug(logging, (Throwable)exception);
                break;
            }
            case INFO: {
                logger.info(logging, (Throwable)exception);
                break;
            }
            case WARNING: {
                logger.warn(logging, (Throwable)exception);
                break;
            }
            case ERROR: {
                logger.error(logging, (Throwable)exception);
                break;
            }
        }
    }

    public static LogLevel[] rankedOrder() {
        LogLevel[] values = LogLevel.values();
        LogLevel[] ret = new LogLevel[values.length];
        System.arraycopy(values, 0, ret, 0, values.length);
        Arrays.sort(ret, COMPARATOR);
        return ret;
    }

    public static LogLevel valueOf(Logger log) {
        if (log.isErrorEnabled()) {
            return ERROR;
        }
        if (log.isWarnEnabled()) {
            return WARNING;
        }
        if (log.isInfoEnabled()) {
            return INFO;
        }
        if (log.isDebugEnabled()) {
            return DEBUG;
        }
        return TRACE;
    }

    static {
        COMPARATOR = new Comparator<LogLevel>(){

            @Override
            public int compare(LogLevel o1, LogLevel o2) {
                return -o1.ordinal() + o2.ordinal();
            }
        };
    }
}

