/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.cascade.ConfigProviderService;
import com.openexchange.config.internal.ConfigProviderServiceImpl;
import com.openexchange.config.internal.ConfigurationImpl;
import com.openexchange.config.internal.filewatcher.FileWatcher;
import com.openexchange.config.osgi.ManagedServiceTracker;
import com.openexchange.osgi.HousekeepingActivator;
import java.util.Collection;
import java.util.Hashtable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigActivator
extends HousekeepingActivator {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigActivator.class);
    private volatile ServiceReference<ManagedService> managedServiceReference;

    protected Class<?>[] getNeededServices() {
        return EMPTY_CLASSES;
    }

    protected void startBundle() throws Exception {
        LOG.info("starting bundle: com.openexchange.configread");
        try {
            ConfigurationImpl configService = new ConfigurationImpl();
            this.registerService(ConfigurationService.class, configService, null);
            Hashtable<String, String> properties = new Hashtable<String, String>(2);
            properties.put("scope", "server");
            this.registerService(ConfigProviderService.class, new ConfigProviderServiceImpl(configService), properties);
            Collection serviceReferences = this.context.getServiceReferences(ManagedService.class, null);
            boolean found = false;
            for (ServiceReference reference : serviceReferences) {
                if (!"org.apache.felix.webconsole.internal.servlet.OsgiManager".equals(reference.getProperty("service.pid"))) continue;
                found = true;
                ManagedService managedService = (ManagedService)this.context.getService(reference);
                ManagedServiceTracker.configureWebConsole(managedService, configService);
                this.managedServiceReference = reference;
                break;
            }
            if (!found) {
                this.rememberTracker(new ManagedServiceTracker(this.context, configService));
                this.openTrackers();
            }
        }
        catch (Throwable t) {
            LOG.error("", t);
            throw t instanceof Exception ? (Exception)t : new Exception(t);
        }
    }

    public void stopBundle() {
        LOG.info("stopping bundle: com.openexchange.configread");
        try {
            ServiceReference<ManagedService> reference = this.managedServiceReference;
            if (null != reference) {
                this.context.ungetService(reference);
                this.managedServiceReference = null;
            }
            this.cleanUp();
            FileWatcher.dropTimer();
        }
        catch (Throwable t) {
            LOG.error("", t);
        }
    }
}

