/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.webdav.xml.AppointmentTest;
import java.util.Date;

public class Bug15491Test
extends AppointmentTest {
    private Appointment appointment;
    private int objectId;

    public Bug15491Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setTitle("testBug15491");
        this.appointment.setStartDate(TimeTools.D("10.10.2010 10:00"));
        this.appointment.setEndDate(TimeTools.D("10.10.2010 11:00"));
        this.appointment.setParentFolderID(this.appointmentFolderId);
        this.appointment.setIgnoreConflicts(true);
    }

    protected void tearDown() throws Exception {
        if (this.objectId != -1) {
            Bug15491Test.deleteAppointment(this.getWebConversation(), this.objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        }
        super.tearDown();
    }

    public void testRead() throws Exception {
        System.currentTimeMillis();
        this.objectId = Bug15491Test.insertAppointment(this.getWebConversation(), this.appointment, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment loadAppointment = Bug15491Test.loadAppointment(this.getWebConversation(), this.objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug15491Test.assertNotNull((String)"Loaded Appointment is null", (Object)loadAppointment);
        Bug15491Test.assertNotNull((String)"Uid is null", (Object)loadAppointment.getUid());
        Bug15491Test.assertFalse((String)"Uid is empty", (boolean)loadAppointment.getUid().trim().equals(""));
        Date date = new Date(loadAppointment.getLastModified().getTime() - 1L);
        Appointment[] listAppointments = Bug15491Test.listAppointment(this.getWebConversation(), this.appointmentFolderId, date, true, true, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (Appointment current : listAppointments) {
            if (current.getObjectID() != this.objectId) continue;
            found = true;
            Bug15491Test.assertNotNull((String)"Uid is null", (Object)current.getUid());
            Bug15491Test.assertFalse((String)"Uid is empty", (boolean)current.getUid().trim().equals(""));
            break;
        }
        Bug15491Test.assertTrue((String)"Did not find appointment", (boolean)found);
    }

    public void testWrite() throws Exception {
        System.currentTimeMillis();
        this.appointment.setUid("ichbineineuid");
        this.objectId = Bug15491Test.insertAppointment(this.getWebConversation(), this.appointment, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment loadAppointment = Bug15491Test.loadAppointment(this.getWebConversation(), this.objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug15491Test.assertNotNull((String)"Loaded Appointment is null", (Object)loadAppointment);
        Bug15491Test.assertNotNull((String)"Uid is null", (Object)loadAppointment.getUid());
        Bug15491Test.assertEquals((String)"Wrong Uid", (String)"ichbineineuid", (String)loadAppointment.getUid());
        Date date = new Date(loadAppointment.getLastModified().getTime() - 1L);
        Appointment[] listAppointments = Bug15491Test.listAppointment(this.getWebConversation(), this.appointmentFolderId, date, true, true, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (Appointment current : listAppointments) {
            if (current.getObjectID() != this.objectId) continue;
            found = true;
            Bug15491Test.assertNotNull((String)"Uid is null", (Object)current.getUid());
            Bug15491Test.assertEquals((String)"Wrong Uid", (String)"ichbineineuid", (String)current.getUid());
            break;
        }
        Bug15491Test.assertTrue((String)"Did not find appointment", (boolean)found);
    }
}

