/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.meterware.httpunit.WebConversation;
import com.openexchange.group.Group;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Charsets;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceGroup;
import com.openexchange.webdav.xml.AbstractWebdavXMLTest;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.framework.RequestTools;
import com.openexchange.webdav.xml.parser.ResponseParser;
import com.openexchange.webdav.xml.request.PropFindMethod;
import com.openexchange.webdav.xml.types.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class GroupUserTest
extends AbstractWebdavXMLTest {
    private static final Log LOG = LogFactory.getLog(GroupUserTest.class);
    public static final String GROUPUSER_URL = "/servlet/webdav.groupuser";

    public GroupUserTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSearchUser() throws Exception {
        Contact[] contactObj = GroupUserTest.searchUser(this.webCon, "*", new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
        for (int a = 0; a < contactObj.length; ++a) {
            GroupUserTest.assertTrue((String)"id > 0 expected", (contactObj[a].getInternalUserId() > 0 ? 1 : 0) != 0);
            GroupUserTest.assertNotNull((String)"last modified is null", (Object)contactObj[a].getLastModified());
        }
    }

    public void testSearchGroup() throws Exception {
        Group[] group = GroupUserTest.searchGroup(this.webCon, "*", new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
        for (int a = 0; a < group.length; ++a) {
            GroupUserTest.assertNotNull((String)"last modified is null", (Object)group[a].getLastModified());
        }
    }

    public void testSearchResource() throws Exception {
        Resource[] resource = GroupUserTest.searchResource(this.getWebConversation(), "*", new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
        for (int a = 0; a < resource.length; ++a) {
            GroupUserTest.assertTrue((String)"id > 0 expected", (resource[a].getIdentifier() > 0 ? 1 : 0) != 0);
            GroupUserTest.assertNotNull((String)"last modified is null", (Object)resource[a].getLastModified());
        }
    }

    public void testSearchGroupWithLastModifed() throws Exception {
        Group[] group = GroupUserTest.searchGroup(this.getWebConversation(), "*", new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
        GroupUserTest.assertTrue((String)"no group found in response (group array length == 0)", (group.length > 0 ? 1 : 0) != 0);
        int posInArray = -1;
        for (int a = 0; a < group.length; ++a) {
            if (group[a].getIdentifier() <= 0) continue;
            posInArray = a;
            break;
        }
        GroupUserTest.assertFalse((String)"No according group found.", (-1 == posInArray ? 1 : 0) != 0);
        int id = group[posInArray].getIdentifier();
        String displayName = group[posInArray].getDisplayName();
        Date lastModifed = group[posInArray].getLastModified();
        group = GroupUserTest.searchGroup(this.getWebConversation(), displayName, new Date(lastModifed.getTime() + 5000L), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (int a = 0; a < group.length; ++a) {
            if (group[a].getIdentifier() != id) continue;
            found = true;
            break;
        }
        GroupUserTest.assertFalse((String)"unexpected id found in response", (boolean)found);
    }

    public void testSearchResourceWithLastModifed() throws Exception {
        Resource[] resource = GroupUserTest.searchResource(this.getWebConversation(), "*", new Date(0L), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        GroupUserTest.assertTrue((String)"no group found in response (group array length == 0)", (resource.length > 0 ? 1 : 0) != 0);
        int posInArray = 0;
        for (int a = 0; a < resource.length; ++a) {
            if (resource[a].getIdentifier() == 1) continue;
            posInArray = a;
            break;
        }
        int id = resource[posInArray].getIdentifier();
        String displayName = resource[posInArray].getDisplayName();
        Date lastModifed = resource[posInArray].getLastModified();
        resource = GroupUserTest.searchResource(this.getWebConversation(), displayName, new Date(lastModifed.getTime() + 5000L), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (int a = 0; a < resource.length; ++a) {
            if (resource[a].getIdentifier() != id) continue;
            found = true;
            break;
        }
        GroupUserTest.assertFalse((String)"unexpected id found in response", (boolean)found);
    }

    public void testSearchResourceGroup() throws Exception {
        GroupUserTest.searchResourcegroup(this.webCon, "*", new Date(0L), "http://" + this.hostName, this.login, this.password);
    }

    public void testGetUserId() throws Exception {
        int userId = GroupUserTest.getUserId(this.getWebConversation(), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        GroupUserTest.assertTrue((String)"user id for login user not found", (userId != -1 ? 1 : 0) != 0);
    }

    public void testGetContextId() throws Exception {
        int contextId = GroupUserTest.getContextId(this.getWebConversation(), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        GroupUserTest.assertTrue((String)"context id for login user not found", (contextId != -1 ? 1 : 0) != 0);
    }

    public static Contact[] searchUser(WebConversation webCon, String searchpattern, Date modified, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element eUsers = new Element("user", XmlServlet.NS);
        eUsers.addContent(searchpattern);
        Document doc = RequestTools.addElement2PropFind(eUsers, modified);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(login + "@" + context, password));
        PropFindMethod propFindMethod = new PropFindMethod(host + GROUPUSER_URL);
        propFindMethod.setDoAuthentication(true);
        LOG.debug((Object)("Request Body: " + new String(baos.toByteArray(), Charsets.UTF_8)));
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        if (status != 207) {
            GroupUserTest.fail((String)("Invalid response code '" + status + "'. Response code is not 207 as expected."));
        }
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 115);
        Contact[] contactArray = new Contact[response.length];
        for (int a = 0; a < contactArray.length; ++a) {
            if (response[a].hasError()) {
                GroupUserTest.fail((String)("xml error: " + response[a].getErrorMessage()));
            }
            contactArray[a] = (Contact)response[a].getDataObject();
        }
        return contactArray;
    }

    public static Group[] searchGroup(WebConversation webCon, String searchpattern, Date modified, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element eGroups = new Element("group", XmlServlet.NS);
        eGroups.addContent(searchpattern);
        Document doc = RequestTools.addElement2PropFind(eGroups, modified);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(login + "@" + context, password));
        PropFindMethod propFindMethod = new PropFindMethod(host + GROUPUSER_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        GroupUserTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 115);
        Group[] groupArray = new Group[response.length];
        for (int a = 0; a < groupArray.length; ++a) {
            if (response[a].hasError()) {
                GroupUserTest.fail((String)("xml error: " + response[a].getErrorMessage()));
            }
            groupArray[a] = (Group)response[a].getDataObject();
        }
        return groupArray;
    }

    public static Resource[] searchResource(WebConversation webCon, String searchpattern, Date modified, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element eResources = new Element("resource", XmlServlet.NS);
        eResources.addContent(searchpattern);
        Document doc = RequestTools.addElement2PropFind(eResources, modified);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(login + "@" + context, password));
        PropFindMethod propFindMethod = new PropFindMethod(host + GROUPUSER_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        GroupUserTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 115);
        Resource[] resourceArray = new Resource[response.length];
        for (int a = 0; a < resourceArray.length; ++a) {
            if (response[a].hasError()) {
                GroupUserTest.fail((String)("xml error: " + response[a].getErrorMessage()));
            }
            resourceArray[a] = (Resource)response[a].getDataObject();
        }
        return resourceArray;
    }

    public static ResourceGroup[] searchResourcegroup(WebConversation webCon, String searchpattern, Date modified, String host, String login, String password) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element eResourceGroups = new Element("resourcegroup", XmlServlet.NS);
        eResourceGroups.addContent(searchpattern);
        Document doc = RequestTools.addElement2PropFind(eResourceGroups, modified);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(login, password));
        PropFindMethod propFindMethod = new PropFindMethod(host + GROUPUSER_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        GroupUserTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 115);
        ResourceGroup[] resourcegroupArray = new ResourceGroup[response.length];
        for (int a = 0; a < resourcegroupArray.length; ++a) {
            if (response[a].hasError()) {
                GroupUserTest.fail((String)("xml error: " + response[a].getErrorMessage()));
            }
            resourcegroupArray[a] = (ResourceGroup)response[a].getDataObject();
        }
        return resourcegroupArray;
    }

    public static int getUserId(WebConversation webCon, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Contact[] contactArray = GroupUserTest.searchUser(webCon, "*", new Date(0L), host, login, password, context);
        for (int a = 0; a < contactArray.length; ++a) {
            Contact contactObj = contactArray[a];
            Map m = contactObj.getMap();
            if (m == null || !m.containsKey("myidentity")) continue;
            return contactObj.getInternalUserId();
        }
        return -1;
    }

    public static int getContextId(WebConversation webCon, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Contact[] contactArray = GroupUserTest.searchUser(webCon, "*", new Date(0L), host, login, password, context);
        for (int a = 0; a < contactArray.length; ++a) {
            Contact contactObj = contactArray[a];
            Map m = contactObj.getMap();
            if (m == null || !m.containsKey("context_id")) continue;
            return Integer.parseInt(m.get("context_id").toString());
        }
        return -1;
    }
}

