/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.webdav.protocol.CollectionTest;
import com.openexchange.webdav.protocol.TestWebdavFactoryBuilder;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public abstract class ActionTestCase
extends TestCase {
    protected List<WebdavPath> clean = new LinkedList<WebdavPath>();
    protected WebdavFactory factory = null;
    protected WebdavPath testCollection = null;

    public void setUp() throws Exception {
        TestWebdavFactoryBuilder.setUp();
        this.factory = TestWebdavFactoryBuilder.buildFactory();
        this.factory.beginRequest();
        try {
            this.testCollection = new WebdavPath(new String[]{"public_infostore", "testCollection" + System.currentTimeMillis()});
            WebdavCollection coll = this.factory.resolveCollection(this.testCollection);
            coll.create();
            this.clean.add(coll.getUrl());
            CollectionTest.createStructure(coll, this.factory);
        }
        catch (Exception x) {
            x.printStackTrace();
            this.tearDown();
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            for (WebdavPath url : this.clean) {
                this.factory.resolveResource(url).delete();
            }
        }
        finally {
            this.factory.endRequest(200);
            TestWebdavFactoryBuilder.tearDown();
        }
    }

    public String getContent(WebdavPath url) throws OXException, IOException {
        WebdavResource res = this.factory.resolveResource(url);
        byte[] bytes = new byte[(int)res.getLength().longValue()];
        InputStream in = res.getBody();
        in.read(bytes);
        return new String(bytes, Charsets.UTF_8);
    }
}

