/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.osgi;

import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.cookies.CookieJar;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.LoginTest;
import com.openexchange.test.osgi.AbstractBundleTest;
import com.openexchange.tools.URLParameter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class BundleTestSMTP
extends AbstractBundleTest {
    private static final String BUNDLE_ID = "com.openexchange.smtp";
    private static final String MAIL_URL = "/ajax/mail";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss", Locale.GERMAN);
    private static Pattern CALLBACK_ARG_PATTERN = Pattern.compile("callback\\s*\\((\\{.*?)\\);");

    public BundleTestSMTP(String name) {
        super(name);
    }

    public void testSMTPAbsence() {
        try {
            LoginTest loginTest = new LoginTest("LoginTest");
            JSONObject jsonObject = BundleTestSMTP.login(this.getWebConversation(), loginTest.getHostName(), loginTest.getLogin(), loginTest.getPassword());
            BundleTestSMTP.assertTrue((String)"Error contained in returned JSON object", (!jsonObject.has("error") || jsonObject.isNull("error") ? 1 : 0) != 0);
            BundleTestSMTP.assertTrue((String)"Missing session ID", (jsonObject.has("session") && !jsonObject.isNull("session") ? 1 : 0) != 0);
            String sessionId = jsonObject.getString("session");
            JSONObject mailObj = BundleTestSMTP.createSimpleMailObject(loginTest);
            JSONObject mailObject = BundleTestSMTP.sendMail(this.getWebConversation(), loginTest.getHostName(), sessionId, mailObj, true);
            BundleTestSMTP.assertTrue((String)"No error contained in returned JSON object", (mailObject.has("error") && !mailObject.isNull("error") ? 1 : 0) != 0);
            BundleTestSMTP.assertTrue((String)"Missing error code", (mailObject.has("code") && !mailObject.isNull("code") ? 1 : 0) != 0);
            BundleTestSMTP.assertTrue((String)("Unexpected error code: " + mailObject.getString("code")), (boolean)"MSG-0053".equals(mailObject.get("code")));
        }
        catch (Exception e) {
            e.printStackTrace();
            BundleTestSMTP.fail((String)e.getMessage());
        }
    }

    private static JSONObject createSimpleMailObject(AbstractAJAXTest ajaxTest) throws JSONException {
        JSONObject mailObj = new JSONObject();
        mailObj.put("from", (Object)ajaxTest.getSeconduser());
        mailObj.put("to", (Object)ajaxTest.getLogin());
        mailObj.put("subject", (Object)("JUnit Test Mail: " + SDF.format(new Date())));
        JSONArray attachments = new JSONArray();
        JSONObject attach = new JSONObject();
        attach.put("content", (Object)"This is mail text!<br>Next line<br/><br/>best regards,<br>Max Mustermann");
        attach.put("content_type", (Object)"text/plain");
        attachments.put((Object)attach);
        mailObj.put("attachments", (Object)attachments);
        return mailObj;
    }

    private static JSONObject sendMail(WebConversation conversation, String hostname, String sessionId, JSONObject mailObj, boolean setCookie) throws Exception {
        return BundleTestSMTP.sendMail(conversation, hostname, sessionId, mailObj.toString(), setCookie);
    }

    private static JSONObject sendMail(WebConversation conversation, String hostname, String sessionId, String mailObjStr, boolean setCookie) throws Exception {
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", sessionId);
        parameter.setParameter("action", "new");
        PostMethodWebRequest req = null;
        WebResponse resp = null;
        if (setCookie) {
            CookieJar cookieJar = new CookieJar();
            cookieJar.putCookie(LoginServlet.SESSION_PREFIX + sessionId, sessionId);
        }
        PostMethodWebRequest postReq = new PostMethodWebRequest("http://" + hostname + MAIL_URL + parameter.getURLParameters(), true);
        postReq.setParameter("json_0", mailObjStr);
        JSONObject jResponse = null;
        req = postReq;
        resp = conversation.getResource((WebRequest)req);
        jResponse = BundleTestSMTP.extractFromCallback(resp.getText());
        return jResponse;
    }

    private static JSONObject extractFromCallback(String html) throws JSONException {
        Matcher matcher = CALLBACK_ARG_PATTERN.matcher(html);
        if (matcher.find()) {
            String jsonString = matcher.group(1);
            return new JSONObject(jsonString);
        }
        return null;
    }

    @Override
    protected String getBundleName() {
        return BUNDLE_ID;
    }
}

