/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures.transformators;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.SimpleCredentials;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JChronicDateTransformator
implements Transformator {
    private static final Pattern parenthesesRegex = Pattern.compile("(\\{|\\[|\\(.+\\)|\\]|\\})");
    private static final String fallbackPattern = "dd.MM.yy HH:mm";
    private final FixtureLoader fixtureLoader;

    public JChronicDateTransformator(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Object transform(String value) throws OXException {
        Date date;
        if (null == value) {
            return null;
        }
        TimeZone timeZone = null;
        Matcher matcher = parenthesesRegex.matcher(value);
        if (matcher.find()) {
            String match = matcher.group();
            if (null != match) {
                if ((match = match.substring(1, match.length() - 1)).startsWith("users:") && 6 < match.length()) {
                    String user = match.substring(6);
                    SimpleCredentials credentials = this.fixtureLoader.getFixtures("users", SimpleCredentials.class).getEntry(user).getEntry();
                    timeZone = credentials.getTimeZone();
                } else {
                    String tzID = match.replace(' ', '_');
                    if (JChronicDateTransformator.isAvailable(tzID)) {
                        timeZone = TimeZone.getTimeZone(match);
                    }
                }
            }
            if (null == timeZone) {
                throw OXException.general((String)("unable to parse user / timezone from '" + match.toString() + "'."));
            }
            value = matcher.replaceFirst("").trim();
        }
        if ((date = TimeTools.D(value, timeZone)) == null) {
            throw OXException.general((String)("Can't parse date '" + value + "'"));
        }
        return date;
    }

    private static boolean isAvailable(String timeZoneID) {
        String[] availableIDs = TimeZone.getAvailableIDs();
        for (int i = 0; i < availableIDs.length; ++i) {
            if (!availableIDs[i].equals(timeZoneID)) continue;
            return true;
        }
        return false;
    }
}

