/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures.transformators;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.SimpleCredentials;
import com.openexchange.test.fixtures.transformators.Transformator;

public class CredentialsTransformator
implements Transformator {
    private final FixtureLoader fixtureLoader;

    public CredentialsTransformator(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Object transform(String value) throws OXException {
        if (null == value || 1 > value.length() || !value.contains(":")) {
            throw OXException.general((String)("Unable to transform '" + value + "' into simple credentials"));
        }
        String[] splitted = value.split(":");
        if (splitted.length < 2) {
            throw OXException.general((String)("Unable to transform '" + value + "' into simple credentials"));
        }
        return this.getCredentials(splitted[0], splitted[1]);
    }

    private final SimpleCredentials getCredentials(String fixtureName, String fixtureEntry) throws OXException {
        return this.fixtureLoader.getFixtures(fixtureName, SimpleCredentials.class).getEntry(fixtureEntry).getEntry();
    }
}

