/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug19471StructureTest
extends AbstractMailTest {
    private static final byte[] SIMPLE = "Date: Fri, 12 Aug 2011 17:31:35 +0200 (CEST)\nFrom: jane@doe.de\nTo: mark@nowhere.com\nMessage-ID: <1423407397.2.1313163096085.JavaMail.blubber@bar>\nSubject: New Appointment: Generate ICal\nMIME-Version: 1.0\nContent-Type: multipart/alternative; \n    boundary=\"----=_Part_0_2043410500.1313163095014\"\n\n------=_Part_0_2043410500.1313163095014\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nA new appointment was created by Blubber Foo.\n\nAppointment\n===========\nCreated by: Blubber Foo\nCreated at: Friday, Aug 12, 2011 5:31:00 PM, CEST\nDescription: Generate ICal\n\nStart date: Wednesday, Aug 17, 2011 2:00:00 PM, CEST\nEnd date: Wednesday, Aug 17, 2011 3:00:00 PM, CEST\n\n\nParticipants\n============\nBlubber Foo (accepted)\nmark@nowhere.com (external)\n\nResources\n=========\nNo resources have been scheduled.\n\n========================================== \n------=_Part_0_2043410500.1313163095014\nContent-Type: text/calendar; charset=\"utf-8\"\nContent-Transfer-Encoding: 7bit\n\nBEGIN:VCALENDAR\nPRODID:Open-Xchange\nVERSION:2.0\nCALSCALE:GREGORIAN\nMETHOD:REQUEST\nBEGIN:VEVENT\nDTSTAMP:20110812T153135Z\nSUMMARY:Generate ICal\nDTSTART;TZID=Europe/Berlin:20110817T140000\nDTEND;TZID=Europe/Berlin:20110817T150000\nCLASS:PUBLIC\nTRANSP:OPAQUE\nUID:cb3f5f83-a2de-4554-b352-78429527d259\nCREATED:20110812T153134Z\nLAST-MODIFIED:20110812T153134Z\nORGANIZER:mailto:jane@doe.de\nATTENDEE;ROLE=REQ-PARTICIPANT;CUTYPE=INDIVIDUAL:mailto:thorben@devel-mail.n\n etline.de\nATTENDEE;CUTYPE=INDIVIDUAL;PARTSTAT=NEEDS-ACTION;ROLE=REQ-PARTICIPANT;RSVP=\n TRUE:mailto:mark@nowhere.com\nEND:VEVENT\nBEGIN:VTIMEZONE\nTZID:Europe/Berlin\nTZURL:http://tzurl.org/zoneinfo/Europe/Berlin\nX-LIC-LOCATION:Europe/Berlin\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19810329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19961027T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:STANDARD\nTZOFFSETFROM:+005328\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:18930401T000000\nRDATE:18930401T000000\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19160430T230000\nRDATE:19160430T230000\nRDATE:19170416T020000\nRDATE:19180415T020000\nRDATE:19400401T020000\nRDATE:19430329T020000\nRDATE:19440403T020000\nRDATE:19450402T020000\nRDATE:19460414T020000\nRDATE:19470406T030000\nRDATE:19480418T020000\nRDATE:19490410T020000\nRDATE:19800406T020000\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19161001T010000\nRDATE:19161001T010000\nRDATE:19170917T030000\nRDATE:19180916T030000\nRDATE:19421102T030000\nRDATE:19431004T030000\nRDATE:19441002T030000\nRDATE:19451118T030000\nRDATE:19461007T030000\nRDATE:19471005T030000\nRDATE:19481003T030000\nRDATE:19491002T030000\nRDATE:19800928T030000\nRDATE:19810927T030000\nRDATE:19820926T030000\nRDATE:19830925T030000\nRDATE:19840930T030000\nRDATE:19850929T030000\nRDATE:19860928T030000\nRDATE:19870927T030000\nRDATE:19880925T030000\nRDATE:19890924T030000\nRDATE:19900930T030000\nRDATE:19910929T030000\nRDATE:19920927T030000\nRDATE:19930926T030000\nRDATE:19940925T030000\nRDATE:19950924T030000\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:CEMT\nDTSTART:19450524T020000\nRDATE:19450524T020000\nRDATE:19470511T030000\nEND:DAYLIGHT\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19450924T030000\nRDATE:19450924T030000\nRDATE:19470629T030000\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19460101T000000\nRDATE:19460101T000000\nRDATE:19800101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n\n------=_Part_0_2043410500.1313163095014--\n".getBytes();

    public Bug19471StructureTest() {
    }

    public Bug19471StructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SIMPLE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            Bug19471StructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            Bug19471StructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            Bug19471StructureTest.assertTrue((String)"Body object is not a JSON object.", (boolean)(bodyObject instanceof JSONArray));
            JSONArray jsonBodyArray = (JSONArray)bodyObject;
            JSONObject icalObject = jsonBodyArray.getJSONObject(1);
            JSONObject ct = icalObject.getJSONObject("headers").getJSONObject("content-type");
            JSONObject param = ct.getJSONObject("params");
            Bug19471StructureTest.assertTrue((param.hasAndNotNull("method") && "REQUEST".equals(param.getString("method")) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug19471StructureTest.fail((String)e.getMessage());
        }
    }
}

