/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.update.UpdateTest;
import com.openexchange.groupware.update.tasks.ClearOrphanedInfostoreDocuments;
import com.openexchange.java.Charsets;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.update.ForeignKeyOld;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ClearOrphanedInfostoreDocumentsTest
extends UpdateTest {
    private final List<String> paths = new ArrayList<String>();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Connection con = this.getProvider().getWriteConnection(this.ctx);
        List foreignKeys = ForeignKeyOld.getForeignKeys((Connection)con, (String)"infostore_document");
        for (ForeignKeyOld foreignKey : foreignKeys) {
            try {
                foreignKey.drop(con);
            }
            catch (SQLException x) {}
        }
        this.createOrphanedInfostoreDocumentEntry(100000, 1);
        this.createOrphanedInfostoreDocumentEntry(100000, 2);
        this.createOrphanedInfostoreDocumentEntry(100000, 3);
    }

    @Override
    public void tearDown() throws SQLException, OXException, OXException, OXException, OXException {
        this.exec("DELETE FROM infostore_document WHERE infostore_id = ?", 100000);
        this.exec("DELETE FROM del_infostore_document WHERE infostore_id = ?", 100001);
        QuotaFileStorage fs = QuotaFileStorage.getInstance((URI)FilestoreStorage.createURI((Context)this.ctx), (Context)this.ctx);
        for (String path : this.paths) {
            fs.deleteFile(path);
        }
        Connection con = this.getProvider().getWriteConnection(this.ctx);
        List foreignKeys = ForeignKeyOld.getForeignKeys((Connection)con, (String)"infostore_document");
        for (ForeignKeyOld foreignKey : foreignKeys) {
            try {
                foreignKey.drop(con);
            }
            catch (SQLException x) {}
        }
        foreignKeys = ForeignKeyOld.getForeignKeys((Connection)con, (String)"del_infostore_document");
        for (ForeignKeyOld foreignKey : foreignKeys) {
            try {
                foreignKey.drop(con);
            }
            catch (SQLException x) {}
        }
    }

    public void testShouldClearLeftoverDocuments() throws OXException, SQLException {
        this.assertNoResults("SELECT * FROM infostore WHERE id = 100000", new Object[0]);
        new ClearOrphanedInfostoreDocuments().perform(this.schema, this.existing_ctx_id);
        this.assertNoResults("SELECT * FROM infostore_document WHERE infostore_id = 100000", new Object[0]);
        this.assertNotInFilestorage(this.paths);
    }

    public void testShouldBeRunnableTwice() throws OXException {
        new ClearOrphanedInfostoreDocuments().perform(this.schema, this.existing_ctx_id);
        new ClearOrphanedInfostoreDocuments().perform(this.schema, this.existing_ctx_id);
    }

    public void testShouldCreateIndexOnInfostoreDocument() throws OXException, SQLException {
        new ClearOrphanedInfostoreDocuments().perform(this.schema, this.existing_ctx_id);
        ForeignKeyOld fk = new ForeignKeyOld("infostore_document", "infostore_id", "infostore", "id");
        List keys = ForeignKeyOld.getForeignKeys((Connection)this.getProvider().getWriteConnection(this.ctx), (String)"infostore_document");
        ClearOrphanedInfostoreDocumentsTest.assertTrue((boolean)keys.contains(fk));
    }

    private void createOrphanedInfostoreDocumentEntry(int id, int version) throws OXException, OXException, UnsupportedEncodingException, SQLException, OXException {
        QuotaFileStorage fs = QuotaFileStorage.getInstance((URI)FilestoreStorage.createURI((Context)this.ctx), (Context)this.ctx);
        String path = fs.saveNewFile((InputStream)new ByteArrayInputStream("Hallo Welt".getBytes(Charsets.UTF_8)));
        this.paths.add(path);
        this.exec("INSERT INTO infostore_document (cid, infostore_id, version_number, file_store_location, creating_date, last_modified, created_by) VALUES (?,?,?,?, 0,0, ?)", this.ctx.getContextId(), id, version, path, this.user_id);
    }
}

