/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.MockUser;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import java.util.HashMap;
import java.util.Map;

public class MockUserLookup {
    private final Map<Integer, User> users = new HashMap<Integer, User>();

    public User getUser(int uid) throws OXException {
        if (!this.users.containsKey(uid)) {
            throw UserExceptionCode.USER_NOT_FOUND.create(new Object[]{uid});
        }
        return this.users.get(uid);
    }

    public User getUserByMail(String mail) {
        for (User user : this.users.values()) {
            String cur_mail = user.getMail();
            if (cur_mail == null || !cur_mail.equalsIgnoreCase(mail)) continue;
            return user;
        }
        return null;
    }

    public MockUserLookup() {
        String tz = "Europe/Berlin";
        int i = 0;
        MockUser user = new MockUser(++i);
        user.setDisplayName("The Mailadmin");
        user.setPreferredLanguage("en_US");
        user.setTimeZone("Europe/Berlin");
        user.setMail("mailadmin@test.invalid");
        user.setGroups(new int[]{1});
        this.addUser((User)user);
        user = new MockUser(++i);
        user.setDisplayName("User 1");
        user.setPreferredLanguage("en_US");
        user.setTimeZone("Europe/Berlin");
        user.setMail("user1@test.invalid");
        user.setGroups(new int[]{1, 4});
        this.addUser((User)user);
        user = new MockUser(++i);
        user.setDisplayName("User 2");
        user.setPreferredLanguage("de_DE");
        user.setTimeZone("Europe/Berlin");
        user.setMail("user2@test.invalid");
        user.setGroups(new int[]{1, 2});
        this.addUser((User)user);
        user = new MockUser(++i);
        user.setDisplayName("User 3");
        user.setPreferredLanguage("en_US");
        user.setTimeZone("Pacific/Samoa");
        user.setMail("user3@test.invalid");
        user.setGroups(new int[]{1, 4});
        this.addUser((User)user);
        user = new MockUser(++i);
        user.setDisplayName("User 4");
        user.setPreferredLanguage("de_DE");
        user.setTimeZone("Europe/Berlin");
        user.setMail("user4@test.invalid");
        user.setGroups(new int[]{1, 2, 3});
        this.addUser((User)user);
        user = new MockUser(++i);
        user.setDisplayName("User 5");
        user.setPreferredLanguage("en_US");
        user.setTimeZone("Europe/Berlin");
        user.setMail("user5@test.invalid");
        user.setGroups(new int[]{1, 3, 4});
        this.addUser((User)user);
        user = new MockUser(++i);
        user.setDisplayName("User 6");
        user.setPreferredLanguage("de_DE");
        user.setTimeZone("Europe/Berlin");
        user.setMail("user6@test.invalid");
        user.setGroups(new int[]{1, 2});
        this.addUser((User)user);
        user = new MockUser(++i);
        user.setDisplayName("User 7");
        user.setPreferredLanguage("en_US");
        user.setTimeZone("Europe/Berlin");
        user.setMail("user7@test.invalid");
        user.setGroups(new int[]{1, 4});
        this.addUser((User)user);
        user = new MockUser(++i);
        user.setDisplayName("User 8");
        user.setPreferredLanguage("de_DE");
        user.setTimeZone("Europe/Berlin");
        user.setMail("user8@test.invalid");
        user.setGroups(new int[]{1, 2, 3});
        this.addUser((User)user);
        user = new MockUser(++i);
        user.setDisplayName("User 9");
        user.setPreferredLanguage("fr");
        user.setTimeZone("Europe/Berlin");
        user.setMail("user9@test.invalid");
        user.setGroups(new int[]{1, 4});
        this.addUser((User)user);
        user = new MockUser(2000);
        user.setDisplayName("Session User");
        user.setPreferredLanguage("en_US");
        user.setTimeZone("Europe/Berlin");
        user.setMail("primary@test");
        user.setGroups(new int[]{1, 4});
        this.addUser((User)user);
    }

    private void addUser(User user) {
        this.users.put(user.getId(), user);
    }
}

