/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.configuration.AJAXConfig;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.infostore.webdav.InfostoreWebdavFactory;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.TestWebdavFactoryBuilder;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;

public class PermissionTest
extends TestCase
implements SessionHolder {
    private Context ctx;
    private Session session;
    private User user;
    private User user1;
    private User user2;
    private UserPermissionBits permissionBits;
    private UserPermissionBits permissionBits1;
    private UserPermissionBits permissionBits2;
    private User cleanupUser;
    private Session session1;
    private Session session2;
    private FolderObject root;
    private InfostoreWebdavFactory factory;
    private final List<FolderObject> clean = new ArrayList<FolderObject>();

    private static String getUsername(String un) {
        int pos = un.indexOf(64);
        return pos == -1 ? un : un.substring(0, pos);
    }

    public void setUp() throws Exception {
        Init.startServer();
        AJAXConfig.init();
        TestConfig config = new TestConfig();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        UserStorage userStorage = UserStorage.getInstance();
        UserPermissionBitsStorage userConfigStorage = UserPermissionBitsStorage.getInstance();
        this.session1 = SessionObjectWrapper.createSessionObject((int)userStorage.getUserId(PermissionTest.getUsername(AJAXConfig.getProperty(AJAXConfig.Property.LOGIN)), this.ctx), (Context)this.ctx, (String)((Object)((Object)this)).getClass().getName());
        this.user1 = userStorage.getUser(this.session1.getUserId(), this.ctx);
        this.permissionBits1 = userConfigStorage.getUserPermissionBits(this.user1.getId(), this.ctx);
        this.session2 = SessionObjectWrapper.createSessionObject((int)userStorage.getUserId(PermissionTest.getUsername(AJAXConfig.getProperty(AJAXConfig.Property.SECONDUSER)), this.ctx), (Context)this.ctx, (String)((Object)((Object)this)).getClass().getName());
        this.user2 = userStorage.getUser(this.session2.getUserId(), this.ctx);
        this.permissionBits2 = userConfigStorage.getUserPermissionBits(this.user2.getId(), this.ctx);
        OXFolderAccess oxfa = new OXFolderAccess(this.ctx);
        this.root = oxfa.getFolderObject(15);
        this.cleanupUser = this.user1;
        this.switchUser(this.user1);
        TestWebdavFactoryBuilder.setUp();
        this.factory = (InfostoreWebdavFactory)TestWebdavFactoryBuilder.buildFactory();
        this.factory.setSessionHolder((SessionHolder)this);
        this.factory.beginRequest();
    }

    public void tearDown() throws Exception {
        this.switchUser(this.cleanupUser);
        Collections.reverse(this.clean);
        for (FolderObject folderobject : this.clean) {
            this.rm(folderobject.getObjectID());
        }
        this.clean.clear();
        this.factory.endRequest(200);
        Init.stopServer();
    }

    public void testListSubfolders() throws Exception {
        FolderObject parentFolder = this.createFolder(this.root, "parent", this.adminPermission(this.user1), this.permission(this.user2, false, 2, 0, 0, 0));
        this.createFolder(parentFolder, "sub", this.adminPermission(this.user1), this.permission(this.user2, false, 2, 0, 0, 0));
        this.switchUser(this.user2);
        WebdavCollection collection = this.factory.resolveCollection(new WebdavPath(new String[]{"public_infostore", "parent"}));
        List children = collection.getChildren();
        PermissionTest.assertEquals((int)1, (int)children.size());
        PermissionTest.assertEquals((String)"sub", (String)((WebdavResource)children.get(0)).getDisplayName());
    }

    public void testProppatchDocumentWithoutWritePermissions() throws Exception {
        FolderObject testFolder = this.createFolder(this.root, "test" + System.currentTimeMillis(), this.adminPermission(this.user1), this.permission(this.user2, false, 2, 4, 0, 0));
        DocumentMetadata document = this.touch(testFolder, "testDocument");
        WebdavResource resource = this.factory.resolveResource(new WebdavPath(new String[]{"public_infostore", testFolder.getFolderName(), document.getFileName()}));
        this.switchUser(this.user2);
        WebdavProperty prop = new WebdavProperty("http://www.open-xchange.com/testProperties", "test");
        prop.setValue("foo");
        resource.putProperty(prop);
        try {
            resource.save();
            PermissionTest.fail((String)"Shouldn't be able to save this, as user2 doesn't have write permissions");
        }
        catch (WebdavProtocolException x) {
            if (x.getStatus() != 403) {
                x.printStackTrace();
            }
            PermissionTest.assertEquals((String)"Expected Forbidden Status", (int)403, (int)x.getStatus());
        }
    }

    public void testProppatchFolderWithoutWritePermissions() throws Exception {
        FolderObject testFolder = this.createFolder(this.root, "test" + System.currentTimeMillis(), this.adminPermission(this.user1), this.permission(this.user2, false, 2, 4, 0, 0));
        WebdavCollection collection = this.factory.resolveCollection(new WebdavPath(new String[]{"public_infostore", testFolder.getFolderName()}));
        this.switchUser(this.user2);
        WebdavProperty prop = new WebdavProperty("http://www.open-xchange.com/testProperties", "test");
        prop.setValue("foo");
        collection.putProperty(prop);
        try {
            collection.save();
            PermissionTest.fail((String)"Shouldn't be able to save this, as user2 doesn't have write permissions");
        }
        catch (WebdavProtocolException x) {
            if (x.getStatus() != 403) {
                x.printStackTrace();
            }
            PermissionTest.assertEquals((String)"Expected Forbidden Status", (int)403, (int)x.getStatus());
        }
    }

    public void testUpdateDocumentWithWritePermissionsOnly() throws Exception {
        FolderObject testFolder = this.createFolder(this.root, "test" + System.currentTimeMillis(), this.adminPermission(this.user1), this.permission(this.user2, false, 2, 0, 4, 0));
        DocumentMetadata document = this.touch(testFolder, "testDocument");
        WebdavResource resource = this.factory.resolveResource(new WebdavPath(new String[]{"public_infostore", testFolder.getFolderName(), document.getFileName()}));
        this.switchUser(this.user2);
        try {
            resource.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3}));
            resource.save();
            PermissionTest.assertTrue((boolean)true);
        }
        catch (OXException e) {
            e.printStackTrace();
            PermissionTest.fail((String)e.getMessage());
        }
    }

    public void testUpdateFolderWithWritePermissionsOnly() throws Exception {
        FolderObject testFolder = this.createFolder(this.root, "test" + System.currentTimeMillis(), this.adminPermission(this.user1), this.permission(this.user2, false, 2, 0, 4, 0));
        WebdavCollection collection = this.factory.resolveCollection(new WebdavPath(new String[]{"public_infostore", testFolder.getFolderName()}));
        this.switchUser(this.user2);
        try {
            collection.setDisplayName("rename");
            collection.save();
            PermissionTest.assertTrue((boolean)true);
        }
        catch (OXException e) {
            e.printStackTrace();
            PermissionTest.fail((String)e.getMessage());
        }
    }

    public void testDontDulicateDocumentsWithCreateAndWritePermissions() throws Exception {
        FolderObject testFolder = this.createFolder(this.root, "test" + System.currentTimeMillis(), this.adminPermission(this.user1), this.permission(this.user2, false, 4, 0, 2, 0));
        this.switchUser(this.user2);
        WebdavResource resource = this.factory.resolveResource(new WebdavPath(new String[]{"public_infostore", testFolder.getFolderName(), "test.bin"}));
        resource.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[0]));
        resource.create();
        this.factory.endRequest(200);
        this.factory.beginRequest();
        resource = this.factory.resolveResource(new WebdavPath(new String[]{"public_infostore", testFolder.getFolderName(), "test.bin"}));
        resource.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        PermissionTest.assertTrue((boolean)resource.exists());
        resource.save();
        this.switchUser(this.user1);
        TimedResult documents = this.factory.getDatabase().getDocuments((long)testFolder.getObjectID(), this.factory.getSession());
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (DocumentMetadata metadata : SearchIteratorAdapter.toIterable((SearchIterator)documents.results())) {
            String name = metadata.getFileName();
            PermissionTest.assertNotNull((Object)name);
            PermissionTest.assertEquals((String)"test.bin", (String)name);
            Integer value = 0;
            if (null != counter.get(name)) {
                value = (Integer)counter.get(name);
            }
            value = value + 1;
            counter.put(name, value);
        }
        PermissionTest.assertTrue((counter.values().size() > 0 ? 1 : 0) != 0);
        for (Integer count : counter.values()) {
            PermissionTest.assertEquals((Object)new Integer(1), (Object)count);
        }
    }

    public void testDontDulicateOtherPersonsDocumentWithCreateAndWritePermissions() throws Exception {
        FolderObject testFolder = this.createFolder(this.root, "test" + System.currentTimeMillis(), this.adminPermission(this.user1), this.permission(this.user2, false, 4, 0, 2, 0));
        WebdavResource resource = this.factory.resolveResource(new WebdavPath(new String[]{"public_infostore", testFolder.getFolderName(), "test.bin"}));
        resource.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[0]));
        resource.create();
        this.switchUser(this.user2);
        resource = this.factory.resolveResource(new WebdavPath(new String[]{"public_infostore", testFolder.getFolderName(), "test.bin"}));
        try {
            resource.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3}));
            resource.save();
            PermissionTest.fail((String)"Could update document even without write permissions to it");
        }
        catch (WebdavProtocolException x) {
            if (x.getStatus() != 403) {
                x.printStackTrace();
            }
            PermissionTest.assertEquals((int)403, (int)x.getStatus());
        }
    }

    public void testDisallowSavingInRootVirtualFolder() throws Exception {
        WebdavResource res = this.factory.resolveResource("/test.txt");
        try {
            res.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3}));
            res.save();
            PermissionTest.fail((String)"Shouldn't be able to save in root folder");
        }
        catch (WebdavProtocolException x) {
            if (x.getStatus() != 403) {
                x.printStackTrace();
            }
            PermissionTest.assertEquals((int)403, (int)x.getStatus());
        }
    }

    public OCLPermission adminPermission(User user) {
        return this.permission(user, true, 128, 128, 128, 128);
    }

    public OCLPermission permission(User user, boolean fadmin, int fp, int rp, int wp, int dp) {
        OCLPermission perm = new OCLPermission();
        perm.setAllPermission(fp, rp, wp, dp);
        perm.setEntity(user.getId());
        perm.setFolderAdmin(fadmin);
        perm.setGroupPermission(false);
        return perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderObject createFolder(FolderObject parent, String fname, OCLPermission ... permissions) throws OXException, OXException {
        if (permissions.length == 0) {
            permissions = new OCLPermission[]{this.adminPermission(this.cleanupUser)};
        }
        Connection writecon = null;
        try {
            writecon = DBPool.pickupWriteable((Context)this.ctx);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session, (Connection)writecon, (Connection)writecon);
            FolderObject fo = new FolderObject();
            fo.setFolderName(fname);
            fo.setParentFolderID(parent.getObjectID());
            fo.setModule(8);
            fo.setType(2);
            fo.setPermissionsAsArray(permissions);
            fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            this.clean.add(fo);
            FolderObject folderObject = fo;
            return folderObject;
        }
        finally {
            if (writecon != null) {
                DBPool.pushWrite((Context)this.ctx, (Connection)writecon);
            }
        }
    }

    private DocumentMetadata touch(FolderObject testFolder, String fileName) throws Exception {
        InfostoreFacadeImpl infostore = new InfostoreFacadeImpl((DBProvider)new DBPoolProvider());
        infostore.startTransaction();
        try {
            DocumentMetadataImpl document = new DocumentMetadataImpl();
            document.setFileName(fileName);
            document.setFolderId((long)testFolder.getObjectID());
            ByteArrayInputStream data = new ByteArrayInputStream(new byte[]{1});
            infostore.saveDocument((DocumentMetadata)document, (InputStream)data, System.currentTimeMillis(), ServerSessionAdapter.valueOf((Session)this.session, (Context)this.getContext()));
            DocumentMetadataImpl documentMetadataImpl = document;
            return documentMetadataImpl;
        }
        catch (Exception x) {
            infostore.rollback();
            throw x;
        }
        finally {
            infostore.finish();
        }
    }

    public void switchUser(User user) {
        if (user.getId() == this.user1.getId()) {
            this.session = this.session1;
            this.user = this.user1;
            this.permissionBits = this.permissionBits1;
        } else if (user.getId() == this.user2.getId()) {
            this.session = this.session2;
            this.user = this.user2;
            this.permissionBits = this.permissionBits2;
        } else {
            throw new IllegalArgumentException("I don't know user " + user.getId());
        }
    }

    protected void rm(int objectID) throws SQLException, OXException, OXException, Exception {
        OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
        oxma.deleteFolder(new FolderObject(objectID), true, System.currentTimeMillis());
    }

    public Session getSessionObject() {
        return this.session;
    }

    public Context getContext() {
        return this.ctx;
    }

    public User getUser() {
        return null;
    }
}

