/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.AbstractInfostoreTest;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.java.Charsets;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.session.ServerSession;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;

public class InfostoreFacadeTest
extends AbstractInfostoreTest {
    public void testExists() throws OXException {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setFolderId((long)this.folderId);
        dm.setTitle("Exists Test");
        this.infostore.saveDocumentMetadata((DocumentMetadata)dm, System.currentTimeMillis(), this.session);
        this.clean.add(dm);
        InfostoreFacadeTest.assertTrue((String)"Should Exist", (boolean)this.infostore.exists(dm.getId(), -1, this.session));
        this.infostore.removeDocument(new int[]{dm.getId()}, System.currentTimeMillis(), this.session);
        this.clean.remove(dm);
        InfostoreFacadeTest.assertFalse((String)"Should not exist", (boolean)this.infostore.exists(dm.getId(), -1, this.session));
    }

    public void testNotExistsIfNoReadPermission() throws OXException {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setFolderId((long)this.folderId);
        dm.setTitle("Exists Test");
        this.infostore.saveDocumentMetadata((DocumentMetadata)dm, System.currentTimeMillis(), this.session);
        this.clean.add(dm);
        InfostoreFacadeTest.assertFalse((String)"No read permission so should not exist", (boolean)this.infostore.exists(dm.getId(), -1, this.session2));
    }

    public void testMoveChecksDeletePermission() throws Exception {
        int folderId = this.createFolderWithoutDeletePermissionForSecondUser();
        DocumentMetadata document = this.createEntry(folderId);
        this.failMovingEntryAsOtherUser(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createFolderWithoutDeletePermissionForSecondUser() throws OXException {
        FolderObject folder = new FolderObject();
        folder.setFolderName("bug9555");
        folder.setParentFolderID(this.folderId);
        folder.setType(2);
        folder.setModule(8);
        OCLPermission perm = new OCLPermission();
        perm.setEntity(this.user.getId());
        perm.setFolderAdmin(true);
        perm.setFolderPermission(128);
        perm.setReadObjectPermission(128);
        perm.setWriteObjectPermission(128);
        perm.setDeleteObjectPermission(128);
        perm.setGroupPermission(false);
        OCLPermission perm2 = new OCLPermission();
        perm2.setEntity(0);
        perm2.setGroupPermission(true);
        perm2.setFolderPermission(4);
        perm2.setReadObjectPermission(4);
        perm2.setWriteObjectPermission(4);
        perm2.setDeleteObjectPermission(0);
        folder.setPermissionsAsArray(new OCLPermission[]{perm, perm2});
        Connection writeCon = null;
        try {
            writeCon = this.provider.getWriteConnection(this.ctx);
        }
        finally {
            if (writeCon != null) {
                this.provider.releaseWriteConnection(this.ctx, writeCon);
                writeCon = null;
            }
        }
        OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session, (Connection)writeCon, (Connection)writeCon);
        oxma.createFolder(folder, true, System.currentTimeMillis());
        this.cleanFolders.add(folder);
        return folder.getObjectID();
    }

    public void testShouldRemoveMIMETypeWhenRemovingLastVersionOfAFile() throws OXException {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setFolderId((long)this.folderId);
        dm.setTitle("Exists Test");
        try {
            this.infostore.startTransaction();
            this.infostore.saveDocumentMetadata((DocumentMetadata)dm, System.currentTimeMillis(), this.session);
            dm.setFileMIMEType("text/plain");
            dm.setFileName("bla.txt");
            dm.setFileSize(12L);
            this.infostore.saveDocument((DocumentMetadata)dm, (InputStream)new ByteArrayInputStream("Hallo".getBytes(Charsets.UTF_8)), Long.MAX_VALUE, this.session);
            this.infostore.removeVersion(dm.getId(), new int[]{1}, this.session);
            this.infostore.commit();
        }
        catch (OXException x) {
            x.printStackTrace();
            this.infostore.rollback();
            throw x;
        }
        finally {
            this.infostore.finish();
        }
        dm = this.infostore.getDocumentMetadata(dm.getId(), -1, this.session);
        InfostoreFacadeTest.assertEquals((String)"", (String)dm.getFileMIMEType());
        InfostoreFacadeTest.assertNull((Object)dm.getFileName());
        InfostoreFacadeTest.assertEquals((long)0L, (long)dm.getFileSize());
        this.clean.add(dm);
    }

    public void testTouch() throws Exception {
        DocumentMetadata document = this.createEntry(this.folderId);
        InfostoreFacadeTest.assertNotNull((Object)document.getLastModified());
        InfostoreFacadeTest.assertTrue((document.getLastModified().getTime() != 0L ? 1 : 0) != 0);
        Thread.sleep(100L);
        this.infostore.touch(document.getId(), this.session);
        DocumentMetadata reload = this.load(document.getId(), this.session);
        InfostoreFacadeTest.assertTrue((String)"lastModified did not change", (reload.getLastModified().getTime() > document.getLastModified().getTime() ? 1 : 0) != 0);
    }

    private DocumentMetadata load(int id, ServerSession session) throws OXException {
        return this.infostore.getDocumentMetadata(id, -1, session);
    }

    private DocumentMetadata createEntry(int fid) throws OXException {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setFolderId((long)fid);
        dm.setTitle("Exists Test");
        this.infostore.saveDocumentMetadata((DocumentMetadata)dm, System.currentTimeMillis(), this.session);
        this.clean.add(dm);
        return dm;
    }

    private void failMovingEntryAsOtherUser(DocumentMetadata document) {
        document.setFolderId((long)this.folderId2);
        try {
            this.infostore.saveDocumentMetadata(document, Long.MAX_VALUE, this.session2);
            InfostoreFacadeTest.fail((String)"Shouldn't be able to move without delete permissions");
        }
        catch (OXException x) {
            x.printStackTrace();
            InfostoreFacadeTest.assertTrue((boolean)true);
        }
    }
}

