/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.utils.DelUserFolderDiscoverer;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.CapabilityUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderTools;
import java.util.List;
import junit.framework.TestCase;

public class DelUserFolderDiscovererTest
extends TestCase {
    private DelUserFolderDiscoverer discoverer = null;
    private Context ctx;
    private int userIdA;
    private int userIdB;
    private User userA;
    private User userB;
    private UserConfiguration userConfigA;
    private UserConfiguration userConfigB;
    private SessionObject session;
    private FolderObject privateInfostoreFolder;
    private FolderObject folderWithOtherEntity;

    private static String getUsername(String un) {
        int pos = un.indexOf(64);
        return pos == -1 ? un : un.substring(0, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Init.startServer();
        TestConfig config = new TestConfig();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        String userNameA = AjaxInit.getAJAXProperty("login");
        String userNameB = AjaxInit.getAJAXProperty("seconduser");
        this.userIdA = UserStorage.getInstance().getUserId(DelUserFolderDiscovererTest.getUsername(userNameA), this.ctx);
        this.userIdB = UserStorage.getInstance().getUserId(DelUserFolderDiscovererTest.getUsername(userNameB), this.ctx);
        this.userA = UserStorage.getInstance().getUser(this.userIdA, this.ctx);
        this.userB = UserStorage.getInstance().getUser(this.userIdB, this.ctx);
        this.userConfigA = CapabilityUserConfigurationStorage.loadUserConfiguration((int)this.userIdA, (Context)this.ctx);
        this.userConfigB = CapabilityUserConfigurationStorage.loadUserConfiguration((int)this.userIdB, (Context)this.ctx);
        this.session = SessionObjectWrapper.createSessionObject((int)this.userIdA, (Context)this.ctx, (String)"blupp");
        SearchIterator iter = OXFolderTools.getAllVisibleFoldersIteratorOfModule((int)this.userIdA, (int[])this.userA.getGroups(), (int[])this.userConfigA.getAccessibleModules(), (int)8, (Context)this.ctx);
        try {
            while (this.privateInfostoreFolder == null && iter.hasNext()) {
                FolderObject f = (FolderObject)iter.next();
                List perms = f.getPermissions();
                if (!f.isDefaultFolder()) continue;
                for (OCLPermission perm : perms) {
                    if (perm.getFolderPermission() < 128 || perm.getEntity() != this.userIdA) continue;
                    this.privateInfostoreFolder = f;
                }
            }
        }
        finally {
            iter.close();
        }
        DelUserFolderDiscovererTest.assertTrue((String)"Can't find suitable infostore folder", (null != this.privateInfostoreFolder ? 1 : 0) != 0);
        this.folderWithOtherEntity = new FolderObject();
        this.addDefaults(this.folderWithOtherEntity);
        this.folderWithOtherEntity.setFolderName("Folder with other entity");
        OCLPermission perm1 = this.buildReadAll(this.userIdA, true);
        OCLPermission perm2 = this.buildReadOwn(this.userIdB, false);
        this.folderWithOtherEntity.setPermissionsAsArray(new OCLPermission[]{perm1, perm2});
        OXFolderManager manager = OXFolderManager.getInstance((Session)this.session);
        manager.createFolder(this.folderWithOtherEntity, true, System.currentTimeMillis());
        this.discoverer = new DelUserFolderDiscoverer((DBProvider)new DBPoolProvider());
    }

    public void tearDown() throws Exception {
        OXFolderManager manager = OXFolderManager.getInstance((Session)this.session);
        manager.deleteFolder(this.folderWithOtherEntity, true, System.currentTimeMillis());
        Init.stopServer();
    }

    public void testDiscoverFolders() throws Exception {
        List folders = this.discoverer.discoverFolders(this.userIdA, this.ctx);
        boolean privateFolderFound = false;
        for (FolderObject folder : folders) {
            DelUserFolderDiscovererTest.assertFalse((folder.getObjectID() == this.folderWithOtherEntity.getObjectID() ? 1 : 0) != 0);
            this.assertOnlyUserCanRead(folder, this.userIdA);
            privateFolderFound = privateFolderFound || this.privateInfostoreFolder.getObjectID() == folder.getObjectID();
        }
        DelUserFolderDiscovererTest.assertTrue((boolean)privateFolderFound);
    }

    private void assertOnlyUserCanRead(FolderObject folder, int userIdA) {
        boolean userCanRead = false;
        for (OCLPermission perm : folder.getPermissions()) {
            if (perm.isGroupPermission()) {
                DelUserFolderDiscovererTest.assertFalse((perm.canReadOwnObjects() || perm.canReadAllObjects() ? 1 : 0) != 0);
                continue;
            }
            if (userIdA != perm.getEntity()) {
                DelUserFolderDiscovererTest.assertFalse((perm.canReadOwnObjects() || perm.canReadAllObjects() ? 1 : 0) != 0);
                continue;
            }
            userCanRead = userCanRead || perm.canReadAllObjects() || perm.canReadOwnObjects();
        }
        DelUserFolderDiscovererTest.assertTrue((boolean)userCanRead);
    }

    private void addDefaults(FolderObject folder) {
        folder.setType(2);
        folder.setModule(8);
        folder.setParentFolderID(this.privateInfostoreFolder.getObjectID());
    }

    private OCLPermission buildReadAll(int userId, boolean admin) {
        OCLPermission perm = new OCLPermission();
        perm.setFolderAdmin(admin);
        if (admin) {
            perm.setFolderPermission(128);
        } else {
            perm.setFolderPermission(8);
        }
        perm.setReadObjectPermission(4);
        perm.setWriteObjectPermission(4);
        perm.setDeleteObjectPermission(4);
        perm.setGroupPermission(false);
        perm.setEntity(userId);
        return perm;
    }

    private OCLPermission buildReadOwn(int userId, boolean admin) {
        OCLPermission perm = new OCLPermission();
        perm.setFolderAdmin(admin);
        if (admin) {
            perm.setFolderPermission(128);
        } else {
            perm.setFolderPermission(8);
        }
        perm.setFolderPermission(128);
        perm.setReadObjectPermission(2);
        perm.setWriteObjectPermission(2);
        perm.setDeleteObjectPermission(2);
        perm.setGroupPermission(false);
        perm.setEntity(userId);
        return perm;
    }
}

