/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarConfig;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.ConfigHook;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.calendar.tools.CommonAppointments;

public class UserStory1906Test
extends CalendarSqlTest {
    private CalendarDataObject appointment;
    private boolean parameterValue;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.parameterValue = CalendarConfig.getUndefinedStatusConflict();
        CalendarDataObject app1 = this.appointments.buildAppointmentWithUserParticipants(this.user);
        app1.setStartDate(CommonAppointments.D("01.07.2020 08:00"));
        app1.setEndDate(CommonAppointments.D("01.07.2020 09:00"));
        app1.setIgnoreConflicts(false);
        this.appointments.save(app1);
        this.clean.add(app1);
        this.appointments.switchUser(this.secondUser);
        this.appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.secondUser);
        this.appointment.setStartDate(CommonAppointments.D("01.07.2020 08:00"));
        this.appointment.setEndDate(CommonAppointments.D("01.07.2020 09:00"));
        this.appointment.setIgnoreConflicts(false);
    }

    public void testTrue() throws Exception {
        ConfigHook.setUndefinedStatusConflict((boolean)true);
        CalendarDataObject[] conflicts = this.appointments.save(this.appointment);
        UserStory1906Test.assertNotNull((String)"Expected conflicts", (Object)conflicts);
        UserStory1906Test.assertTrue((String)"Expected conflicts", (conflicts.length > 0 ? 1 : 0) != 0);
    }

    public void testFalse() throws Exception {
        ConfigHook.setUndefinedStatusConflict((boolean)false);
        CalendarDataObject[] conflicts = this.appointments.save(this.appointment);
        UserStory1906Test.assertNull((String)"Expected no conflicts", (Object)conflicts);
    }

    @Override
    public void tearDown() throws Exception {
        ConfigHook.setUndefinedStatusConflict((boolean)this.parameterValue);
        if (this.appointment.getObjectID() > 0) {
            this.clean.add(this.appointment);
        }
        super.tearDown();
    }
}

