/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.Participant;
import java.util.Calendar;

public class Bug29339Test
extends CalendarSqlTest {
    private CalendarDataObject appointment;
    private CalendarDataObject appointment2;
    private int resourceId;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        int nextYear = Calendar.getInstance().get(1) + 1;
        this.appointment = this.appointments.buildAppointmentWithResourceParticipants(this.resource1);
        this.appointment.setParentFolderID(this.appointments.getPrivateFolder());
        this.appointment.setTitle("Bug 29339 Test");
        this.appointment.setStartDate(TimeTools.D("26.10." + nextYear + " 00:00"));
        this.appointment.setEndDate(TimeTools.D("27.10." + nextYear + " 00:00"));
        this.appointment.setFullTime(true);
        this.appointment.setIgnoreConflicts(true);
        this.appointments.save(this.appointment);
        this.clean.add(this.appointment);
        this.resourceId = this.getResourceId(this.appointment);
        this.appointments.switchUser(this.secondUser);
        this.appointment2 = this.appointments.buildAppointmentWithResourceParticipants(this.resource1);
        this.appointment2.setTitle("Bug 29339 Test conflict.");
        this.appointment2.setParentFolderID(this.appointments.getPrivateFolder());
        this.appointment2.setStartDate(TimeTools.D("25.10." + nextYear + " 15:00"));
        this.appointment2.setEndDate(TimeTools.D("26.10." + nextYear + " 15:00"));
        this.appointment2.setIgnoreConflicts(false);
    }

    public void testBug29339() throws Exception {
        CalendarDataObject[] conflicts = this.appointments.save(this.appointment2);
        this.clean.add(this.appointment2);
        Bug29339Test.assertTrue((String)"Missing conflicts.", (conflicts != null && conflicts.length > 0 ? 1 : 0) != 0);
        boolean found = false;
        block0: for (CalendarDataObject conflict : conflicts) {
            for (Participant participant : conflict.getParticipants()) {
                if (participant.getType() != 3 || participant.getIdentifier() != this.resourceId) continue;
                found = true;
                continue block0;
            }
        }
        Bug29339Test.assertTrue((String)"Missing resource conflict.", (boolean)found);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    private int getResourceId(CalendarDataObject app) {
        for (Participant p : app.getParticipants()) {
            if (p.getType() != 3) continue;
            return p.getIdentifier();
        }
        return -1;
    }
}

