/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.setuptools.TestContextToolkit;

public class Bug12509Test
extends CalendarSqlTest {
    public void testChangeExcResidedInSameFolder() {
        try {
            FolderObject folder = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "A nice private folder_" + System.currentTimeMillis(), this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder);
            this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId, folder);
            TestContextToolkit tools = new TestContextToolkit();
            int secondParticipantDefaultFolder = this.folders.getStandardFolder(tools.resolveUser(this.participant2, this.ctx), this.ctx);
            CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant2);
            appointment.setParentFolderID(folder.getObjectID());
            appointment.setStartDate(CommonAppointments.D("11/03/2008 10:00"));
            appointment.setEndDate(CommonAppointments.D("11/03/2008 11:00"));
            appointment.setRecurrenceType(1);
            appointment.setInterval(1);
            appointment.setOccurrence(5);
            appointment.setIgnoreConflicts(true);
            this.appointments.save(appointment);
            this.clean.add(appointment);
            this.appointments.switchUser(this.secondUser);
            CalendarDataObject update = this.appointments.createIdentifyingCopy(appointment);
            update.setRecurrencePosition(2);
            update.setStartDate(CommonAppointments.D("11/04/2008 12:00"));
            update.setEndDate(CommonAppointments.D("11/04/2008 13:00"));
            update.setIgnoreConflicts(true);
            this.appointments.save(update);
            this.clean.add(update);
            this.appointments.switchUser(this.user);
            CalendarDataObject reloadedException = this.appointments.reload(update);
            Bug12509Test.assertEquals((String)"Change-exception's start NOT changed", (Object)CommonAppointments.D("11/04/2008 12:00"), (Object)reloadedException.getStartDate());
            Bug12509Test.assertEquals((String)"Change-exception's end NOT changed", (Object)CommonAppointments.D("11/04/2008 13:00"), (Object)reloadedException.getEndDate());
            UserParticipant[] users = reloadedException.getUsers();
            for (int i = 0; i < users.length; ++i) {
                if (users[i].getIdentifier() == this.session.getUserId()) {
                    Bug12509Test.assertEquals((String)"Change exception NOT located in same folder as recurring appointment", (int)folder.getObjectID(), (int)users[i].getPersonalFolderId());
                    continue;
                }
                Bug12509Test.assertEquals((String)"Change exception NOT located in same folder as recurring appointment", (int)secondParticipantDefaultFolder, (int)users[i].getPersonalFolderId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug12509Test.fail((String)e.getMessage());
        }
    }
}

