/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.calendar.tools.CalendarAssertions;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.setuptools.TestContextToolkit;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class Bug10154Test
extends CalendarSqlTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShouldKeepParticipantsInSharedFolder() throws OXException, SQLException {
        this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId);
        try {
            this.appointments.switchUser(this.secondUser);
            CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user);
            appointment.setParentFolderID(this.folders.getStandardFolder(this.userId, this.ctx));
            this.appointments.save(appointment);
            appointment = this.appointments.reload(appointment);
            this.appointments.switchUser(this.user);
            ArrayList<Participant> participants = new ArrayList<Participant>(Arrays.asList(appointment.getParticipants()));
            TestContextToolkit tk = new TestContextToolkit();
            UserParticipant participant = new UserParticipant(tk.resolveUser(this.participant1));
            participants.add((Participant)participant);
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setObjectID(appointment.getObjectID());
            cdao.setParentFolderID(appointment.getParentFolderID());
            cdao.setContext(appointment.getContext());
            cdao.setParticipants(participants);
            this.appointments.save(cdao);
            this.appointments.switchUser(this.secondUser);
            cdao = new CalendarDataObject();
            cdao.setStartDate(appointment.getStartDate());
            cdao.setEndDate(new Date(appointment.getEndDate().getTime() + 36000000L));
            cdao.setObjectID(appointment.getObjectID());
            cdao.setParentFolderID(appointment.getParentFolderID());
            cdao.setContext(appointment.getContext());
            this.appointments.save(cdao);
            this.appointments.switchUser(this.user);
            appointment = this.appointments.reload(appointment);
            CalendarAssertions.assertUserParticipants(appointment, this.user, this.participant1);
        }
        finally {
            this.folders.unsharePrivateFolder(this.session, this.ctx);
        }
    }
}

