/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.server.impl.DBPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDGeneratorTest
extends TestCase {
    private static final String TEST_TABLE = "CREATE TABLE idGeneratorTest (cid INT4 UNSIGNED NOT NULL, id INT4 UNSIGNED NOT NULL, PRIMARY KEY (cid,id))";
    private static final int TYPE = 4;
    private static final int MAX_IN_COMMIT = 10;
    private static final int THREADS = 10;
    private static final int TIME = 20;
    static final Log LOG = LogFactory.getLog(IDGeneratorTest.class);
    static final Random rand = new Random(System.currentTimeMillis());
    Context context;

    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        ContextStorage cs = ContextStorage.getInstance();
        this.context = cs.getContext(cs.getContextId("defaultcontext"));
    }

    protected void tearDown() throws Exception {
        Init.stopServer();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetId() throws Throwable {
        Statement stmt;
        int i;
        Connection con = DBPool.pickupWriteable((Context)this.context);
        try {
            Statement stmt2 = con.createStatement();
            try {
                stmt2.execute(TEST_TABLE);
            }
            catch (SQLException e) {
                LOG.fatal((Object)"Error while creating test table.", (Throwable)e);
                IDGeneratorTest.fail((String)"Error while creating test table.");
            }
            stmt2.close();
        }
        finally {
            DBPool.closeWriterSilent((Context)this.context, (Connection)con);
            con = null;
        }
        Inserter[] tester = new Inserter[10];
        Thread[] threads = new Thread[tester.length];
        for (i = 0; i < tester.length; ++i) {
            tester[i] = new Inserter();
            threads[i] = new Thread(tester[i]);
            threads[i].start();
        }
        Thread.sleep(20000L);
        for (i = 0; i < tester.length; ++i) {
            tester[i].run = false;
        }
        for (i = 0; i < tester.length; ++i) {
            threads[i].join();
        }
        con = DBPool.pickup((Context)this.context);
        try {
            stmt = con.createStatement();
            ResultSet result = stmt.executeQuery("SELECT count(*) FROM idGeneratorTest");
            int rows = 0;
            if (result.next()) {
                rows = result.getInt(1);
            }
            result.close();
            LOG.info((Object)("Inserted " + (float)rows / 20.0f / 10.0f + " rows."));
            stmt.close();
        }
        finally {
            DBPool.closeReaderSilent((Context)this.context, (Connection)con);
            con = null;
        }
        con = DBPool.pickupWriteable((Context)this.context);
        try {
            stmt = con.createStatement();
            try {
                stmt.execute("DROP TABLE idGeneratorTest");
            }
            catch (SQLException e) {
                LOG.fatal((Object)"Error while dropping table.", (Throwable)e);
            }
            stmt.close();
        }
        finally {
            DBPool.closeWriterSilent((Context)this.context, (Connection)con);
        }
    }

    class Inserter
    implements Runnable {
        boolean run = true;

        Inserter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.run) {
                Connection con = null;
                try {
                    con = DBPool.pickupWriteable((Context)IDGeneratorTest.this.context);
                }
                catch (OXException e) {
                    LOG.error((Object)"Can't get writable database connection.", (Throwable)e);
                    return;
                }
                try {
                    con.setAutoCommit(false);
                    PreparedStatement insert = con.prepareStatement("INSERT INTO idGeneratorTest (cid, id) VALUES (?, ?)");
                    int countInCommit = rand.nextInt(10) + 1;
                    for (int i = 0; i < countInCommit; ++i) {
                        int ident = IDGenerator.getId((Context)IDGeneratorTest.this.context, (int)4, (Connection)con);
                        insert.setInt(1, IDGeneratorTest.this.context.getContextId());
                        insert.setInt(2, ident);
                        insert.executeUpdate();
                    }
                    con.commit();
                    insert.close();
                }
                catch (SQLException e) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException e1) {
                        LOG.fatal((Object)"Error while rollback.", (Throwable)e);
                    }
                    LOG.fatal((Object)"Error while getting ID and inserting.", (Throwable)e);
                    TestCase.fail((String)e.getMessage());
                    return;
                }
                finally {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        LOG.fatal((Object)"Error while setting autocommit true.", (Throwable)e);
                    }
                    DBPool.closeWriterSilent((Context)IDGeneratorTest.this.context, (Connection)con);
                }
            }
        }
    }
}

