/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.groupware.container.Contact;
import java.util.Date;

public class Bug21235Test
extends CardDAVTest {
    public Bug21235Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        super.getWebDAVClient().setUserAgent("Address%20Book/883 CFNetwork/454.12.4 Darwin/10.8.0 (i386)");
    }

    public void testUpdateContact() throws Exception {
        String uid = Bug21235Test.randomUID() + "-ABSPlugin";
        String pathUid = Bug21235Test.randomUID() + "-ABSPlugin";
        String firstName = "test";
        String lastName = "heinz";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:heinz;test;;;\r\nFN:test heinz\r\nCATEGORIES:Kontakte\r\nX-ABUID:A33920F3-656F-47B7-A335-2C603DA3F324\\:ABPerson\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "END:VCARD" + "\r\n";
        Bug21235Test.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(pathUid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Bug21235Test.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        Bug21235Test.assertEquals((String)"firstname wrong", (String)"test", (String)contact.getGivenName());
        Bug21235Test.assertEquals((String)"lastname wrong", (String)"heinz", (String)contact.getSurName());
        String updatedFirstName = "test2";
        String updatedVCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:heinz;test2;;;\r\nFN:test2 heinz\r\nCATEGORIES:Kontakte\r\nX-ABUID:A33920F3-656F-47B7-A335-2C603DA3F324\\:ABPerson\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "END:VCARD" + "\r\n";
        Bug21235Test.assertEquals((String)"response code wrong", (int)201, (int)super.putVCardUpdate(pathUid, updatedVCard));
        Contact updatedContact = super.getContact(uid);
        Bug21235Test.assertEquals((String)"uid wrong", (String)uid, (String)updatedContact.getUid());
        Bug21235Test.assertEquals((String)"firstname wrong", (String)"test2", (String)updatedContact.getGivenName());
        Bug21235Test.assertEquals((String)"lastname wrong", (String)"heinz", (String)updatedContact.getSurName());
    }
}

