/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.storage;

import com.openexchange.contact.storage.ContactStorageTest;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.search.Operand;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.search.internal.operands.ColumnOperand;
import com.openexchange.search.internal.operands.ConstantOperand;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.UUID;
import org.junit.Test;

public class SearchTest
extends ContactStorageTest {
    @Test
    public void testSearchByUID() throws Exception {
        String folderId = "500011";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setDisplayName("Horst Horstensen");
        contact.setGivenName("Horst");
        contact.setSurName("Horstensen");
        contact.setEmail1("horst.horstensen@example.com");
        contact.setUid(UUID.randomUUID().toString());
        this.getStorage().create(this.getSession(), "500011", contact);
        super.rememberForCleanUp(contact);
        SingleSearchTerm term = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
        term.addOperand((Operand)new ColumnOperand("uid"));
        term.addOperand((Operand)new ConstantOperand((Object)contact.getUid()));
        SearchIterator result = this.getStorage().search(this.getSession(), (SearchTerm)term, ContactField.values());
        SearchTest.assertNotNull((String)"got no search result", (Object)result);
        SearchTest.assertTrue((String)"got no search result", (0 < result.size() ? 1 : 0) != 0);
        Contact foundContact = SearchTest.findContact(contact.getUid(), (SearchIterator<Contact>)result);
        SearchTest.assertNotNull((String)"contact not in search results", (Object)foundContact);
        SearchTest.assertEquals((String)"display name wrong", (String)contact.getDisplayName(), (String)foundContact.getDisplayName());
        SearchTest.assertEquals((String)"surname wrong", (String)contact.getSurName(), (String)foundContact.getSurName());
        SearchTest.assertEquals((String)"givenname wrong", (String)contact.getGivenName(), (String)foundContact.getGivenName());
        SearchTest.assertEquals((String)"email1 wrong", (String)contact.getEmail1(), (String)foundContact.getEmail1());
    }
}

