/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class TasksTest
extends AbstractAJAXTest {
    private static final Log LOG = LogFactory.getLog(TasksTest.class);
    private int privateTaskFolder;

    public TasksTest(String name) {
        super(name);
    }

    public void testInsertDelegatedPrivateTask() throws Throwable {
        Task task = new Task();
        task.setTitle("Private delegated task");
        task.setPrivateFlag(false);
        task.setCreationDate(new Date());
        Date lastModified = new Date();
        task.setLastModified(lastModified);
        task.setStartDate(new Date(1133964000000L));
        task.setEndDate(new Date(1133967600000L));
        task.setAfterComplete(new Date(1133971200000L));
        task.setNote("Description");
        task.setStatus(1);
        task.setPriority(2);
        task.setCategories("Categories");
        task.setTargetDuration(Autoboxing.L((long)1440L));
        task.setActualDuration(Autoboxing.L((long)1440L));
        task.setTargetCosts(new BigDecimal("1.0"));
        task.setActualCosts(new BigDecimal("1.0"));
        task.setCurrency("\u20ac");
        task.setTripMeter("trip meter");
        task.setBillingInformation("billing information");
        task.setCompanies("companies");
        int folderId = TaskTools.getPrivateTaskFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        List<Participant> participants = ParticipantTools.getParticipants(this.getWebConversation(), this.getHostName(), this.getSessionId(), 2, true, ConfigTools.getUserId(this.getWebConversation(), this.getHostName(), this.getSessionId()));
        ExternalUserParticipant external = new ExternalUserParticipant("external@external.no");
        external.setDisplayName("External, External");
        participants.add((Participant)external);
        task.setParticipants(participants);
        task.setParentFolderID(folderId);
        int taskId = TaskTools.extractInsertId(TaskTools.insertTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), task));
        LOG.trace((Object)("Created delegated task: " + taskId));
        Response response = TaskTools.getTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, taskId);
        Task reload = (Task)response.getData();
        for (Participant p1 : reload.getParticipants()) {
            boolean found = false;
            for (Participant p2 : participants) {
                if (p1.getIdentifier() != p2.getIdentifier()) continue;
                found = true;
            }
            if (found) continue;
            TasksTest.fail((String)"Storing participant in delegated task failed.");
        }
        lastModified = response.getTimestamp();
        TaskTools.deleteTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), lastModified, folderId, taskId);
    }

    public void testUpdateDelegatedTask() throws Throwable {
        List<Participant> participants = ParticipantTools.getParticipants(this.getWebConversation(), this.getHostName(), this.getSessionId(), 4, true, ConfigTools.getUserId(this.getWebConversation(), this.getHostName(), this.getSessionId()));
        ArrayList<Participant> firstParticipants = new ArrayList<Participant>();
        firstParticipants.addAll(participants.subList(0, 2));
        ArrayList<Participant> secondParticipants = new ArrayList<Participant>();
        secondParticipants.addAll(participants.subList(2, 4));
        secondParticipants.add(participants.get(0));
        Task task = new Task();
        task.setTitle("Private delegated task");
        int folderId = TaskTools.getPrivateTaskFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        task.setParentFolderID(folderId);
        task.setParticipants(firstParticipants);
        LOG.trace((Object)("Creating delegated task with participants: " + firstParticipants));
        int taskId = TaskTools.extractInsertId(TaskTools.insertTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), task));
        LOG.trace((Object)("Created delegated task: " + taskId));
        Response response = TaskTools.getTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, taskId);
        Date lastModified = response.getTimestamp();
        Task reload = (Task)response.getData();
        TasksTest.assertEquals((String)"Number of participants differ", (int)firstParticipants.size(), (int)reload.getParticipants().length);
        for (Participant p1 : firstParticipants) {
            boolean found = false;
            for (Participant p2 : reload.getParticipants()) {
                if (p1.getIdentifier() != p2.getIdentifier()) continue;
                found = true;
            }
            if (found) continue;
            TasksTest.fail((String)("Delegated task misses participant: " + p1.getIdentifier()));
        }
        Task updatedTask = new Task();
        updatedTask.setTitle("Updated delegated task");
        updatedTask.setObjectID(taskId);
        updatedTask.setParticipants(secondParticipants);
        LOG.trace((Object)("Updating delegated task with participants: " + secondParticipants));
        TasksTest.failOnError(TaskTools.updateTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, updatedTask, lastModified));
        response = TaskTools.getTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, taskId);
        lastModified = response.getTimestamp();
        reload = (Task)response.getData();
        TasksTest.assertEquals((String)"Number of participants differ", (int)secondParticipants.size(), (int)reload.getParticipants().length);
        for (Participant p1 : secondParticipants) {
            boolean found = false;
            for (Participant p2 : reload.getParticipants()) {
                if (p1.getIdentifier() != p2.getIdentifier()) continue;
                found = true;
            }
            if (found) continue;
            TasksTest.fail((String)("Delegated task misses participant: " + p1.getIdentifier()));
        }
        TaskTools.deleteTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), lastModified, folderId, taskId);
    }

    public void testUpdate() throws Throwable {
        String title = "Title";
        String updatedTitle = "Complete other title.";
        Task task = new Task();
        task.setTitle("Title");
        int folderId = TaskTools.getPrivateTaskFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        task.setParentFolderID(folderId);
        int taskId = TaskTools.extractInsertId(TaskTools.insertTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), task));
        Response response = TaskTools.getTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, taskId);
        TasksTest.assertTrue((String)"Response can't be parsed to a task.", (boolean)(response.getData() instanceof Task));
        Date lastModified = response.getTimestamp();
        task.setObjectID(taskId);
        task.setTitle("Complete other title.");
        response = TaskTools.updateTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, task, lastModified);
        TasksTest.failOnError(response);
        response = TaskTools.getTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, taskId);
        TasksTest.assertEquals((String)"Title of task is not updated.", (String)"Complete other title.", (String)((Task)response.getData()).getTitle());
        lastModified = response.getTimestamp();
        TaskTools.deleteTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), lastModified, folderId, taskId);
    }

    public void testAllWithOrder() throws Throwable {
        int folderId = TaskTools.getPrivateTaskFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        Task task = new Task();
        task.setParentFolderID(folderId);
        int[][] tasks = new int[10][2];
        for (int i = 0; i < tasks.length; ++i) {
            task.setTitle("Task " + (i + 1));
            tasks[i][1] = TaskTools.extractInsertId(TaskTools.insertTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), task));
            tasks[i][0] = folderId;
        }
        int[] columns = new int[]{200, 1, 5, 20};
        Response response = TaskTools.getAllTasksInFolder(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, columns, 200, "asc");
        response.getData();
        Date lastModified = response.getTimestamp();
        for (int[] folderAndTask : tasks) {
            TaskTools.deleteTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), lastModified, folderAndTask[0], folderAndTask[1]);
        }
    }

    public void testConfirmation() throws Throwable {
        int folderId = this.getPrivateTaskFolder();
        Task task = new Task();
        task.setTitle("Task to test confirmation");
        int folderId2 = TaskTools.getPrivateTaskFolder(this.getSecondWebConversation(), this.getHostName(), this.getSecondSessionId());
        int userId2 = ConfigTools.getUserId(this.getSecondWebConversation(), this.getHostName(), this.getSecondSessionId());
        ArrayList<UserParticipant> participants = new ArrayList<UserParticipant>();
        UserParticipant participant = new UserParticipant(userId2);
        participants.add(participant);
        task.setParticipants(participants);
        task.setParentFolderID(folderId);
        int taskId = TaskTools.extractInsertId(TaskTools.insertTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), task));
        LOG.trace((Object)("Created delegated task for confirmation: " + taskId));
        TaskTools.confirmTask(this.getSecondWebConversation(), this.getHostName(), this.getSecondSessionId(), folderId2, taskId, 1, "Testconfirmation.");
        LOG.trace((Object)"Confirmed task.");
        Response response = TaskTools.getTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, taskId);
        Date lastModified = response.getTimestamp();
        Task reload = (Task)response.getData();
        UserParticipant[] users = reload.getUsers();
        boolean confirmed = false;
        for (UserParticipant user : users) {
            int confirm = user.getConfirm();
            int userId = user.getIdentifier();
            if (userId2 != userId || 1 != confirm) continue;
            confirmed = true;
        }
        TasksTest.assertTrue((String)"Can't find confirmation.", (boolean)confirmed);
        TaskTools.deleteTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), lastModified, folderId, taskId);
    }

    public void testReminder() throws Throwable {
        int folderId = this.getPrivateTaskFolder();
        Task task = new Task();
        task.setTitle("Task to test reminder");
        task.setParentFolderID(folderId);
        long remindTime = System.currentTimeMillis() / 1000L * 1000L;
        Date remind = new Date(remindTime);
        task.setAlarm(remind);
        int taskId = TaskTools.extractInsertId(TaskTools.insertTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), task));
        Response response = TaskTools.getTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, taskId);
        Task reload = (Task)response.getData();
        TasksTest.assertEquals((String)"Missing reminder.", (Object)remind, (Object)reload.getAlarm());
        TaskTools.deleteTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), response.getTimestamp(), folderId, taskId);
    }

    public void testInternalEqualError() throws Throwable {
        int folderId = this.getPrivateTaskFolder();
        Task task = new Task();
        task.setTitle("Title to remove on update");
        task.setNote("Not to remove on update");
        task.setParentFolderID(folderId);
        Response response = TaskTools.insertTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), task);
        task.setObjectID(TaskTools.extractInsertId(response));
        response = TaskTools.getTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, task.getObjectID());
        Date lastModified = TasksTest.extractTimestamp(response);
        JSONObject json = new JSONObject();
        json.put("folder_id", folderId);
        json.put("id", task.getObjectID());
        json.put("title", JSONObject.NULL);
        json.put("note", JSONObject.NULL);
        response = TaskTools.updateTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), folderId, task.getObjectID(), json, lastModified);
        TasksTest.failOnError(response);
        lastModified = TasksTest.extractTimestamp(response);
        TaskTools.deleteTask(this.getWebConversation(), this.getHostName(), this.getSessionId(), lastModified, folderId, task.getObjectID());
    }

    public static Date extractTimestamp(Response response) {
        Date retval = response.getTimestamp();
        TasksTest.assertNotNull((String)"Timestamp is missing.", (Object)retval);
        return retval;
    }

    public static void failOnError(Response response) {
        TasksTest.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
    }

    protected int getPrivateTaskFolder() throws IOException, SAXException, JSONException, OXException, OXException {
        if (0 == this.privateTaskFolder) {
            this.privateTaskFolder = TaskTools.getPrivateTaskFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        }
        return this.privateTaskFolder;
    }
}

