/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.subscribe.actions.AbstractSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.ListSubscriptionsResponse;
import com.openexchange.java.JSON;
import com.openexchange.java.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

public class ListSubscriptionsRequest
extends AbstractSubscriptionRequest<ListSubscriptionsResponse> {
    private List<Integer> IDs;
    private List<String> columns;
    private Map<String, List<String>> dynamicColumns;

    public void setIDs(List<Integer> iDs) {
        this.IDs = iDs;
    }

    public List<Integer> getIDs() {
        return this.IDs;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setDynamicColumns(Map<String, List<String>> dynamicColumns) {
        this.dynamicColumns = dynamicColumns;
    }

    public Map<String, List<String>> getDynamicColumns() {
        return this.dynamicColumns;
    }

    public ListSubscriptionsRequest(List<Integer> ids, List<String> columns) {
        this.setIDs(ids);
        this.setColumns(columns);
    }

    public ListSubscriptionsRequest(List<Integer> ids, List<String> columns, Map<String, List<String>> dynamicColumns) {
        this(ids, columns);
        this.setDynamicColumns(dynamicColumns);
    }

    @Override
    public Object getBody() throws JSONException {
        return JSON.collection2jsonArray(this.getIDs());
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> params = new LinkedList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "list"));
        if (this.getColumns() != null) {
            params.add(new AJAXRequest.Parameter("columns", Strings.join(this.getColumns(), (String)",")));
        }
        if (this.getDynamicColumns() != null) {
            for (String plugin : this.getDynamicColumns().keySet()) {
                params.add(new AJAXRequest.Parameter(plugin, Strings.join((Collection)this.getDynamicColumns().get(plugin), (String)",")));
            }
        }
        return params.toArray(new AJAXRequest.Parameter[0]);
    }

    @Override
    public AbstractAJAXParser<ListSubscriptionsResponse> getParser() {
        return new AbstractAJAXParser<ListSubscriptionsResponse>(this.getFailOnError()){

            @Override
            protected ListSubscriptionsResponse createResponse(Response response) throws JSONException {
                return new ListSubscriptionsResponse(response);
            }
        };
    }
}

