/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.simple.AbstractSimpleClientTest;
import com.openexchange.groupware.calendar.TimeTools;
import java.util.Date;
import org.apache.commons.httpclient.Cookie;

public class StoreTest
extends AbstractSimpleClientTest {
    public StoreTest(String name) {
        super(name);
    }

    public void testStoreStoresSessionInCookie() throws Exception {
        this.as("login");
        this.inModule("login");
        this.call("store", new Object[0]);
        String sessionID = this.currentClient.getSessionID();
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        boolean found = false;
        for (Cookie cookie : cookies) {
            found = found || cookie.getName().startsWith(LoginServlet.SESSION_PREFIX) && cookie.getValue().equals(sessionID);
        }
        StoreTest.assertTrue((boolean)found);
    }

    public void testCookieLifetimeIsLongerThanADay() throws Exception {
        this.as("login");
        this.inModule("login");
        this.call("store", new Object[0]);
        String sessionID = this.currentClient.getSessionID();
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        Cookie sessionCookie = null;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().startsWith(LoginServlet.SESSION_PREFIX) || !cookie.getValue().equals(sessionID)) continue;
            sessionCookie = cookie;
            break;
        }
        StoreTest.assertNotNull(sessionCookie);
        StoreTest.assertNotNull((Object)sessionCookie.getExpiryDate());
        Date tomorrow = TimeTools.D("tomorrow");
        StoreTest.assertTrue((boolean)sessionCookie.getExpiryDate().after(tomorrow));
    }

    public void testNonExistingSessionID() throws Exception {
        this.as("login");
        this.inModule("login");
        this.call("store", "session", "1233456");
        this.assertError();
    }

    public void testExistingButDifferentSessionID() throws Exception {
        this.as("login");
        String sessionID = this.currentClient.getSessionID();
        this.as("seconduser");
        this.inModule("login");
        this.call("store", "session", sessionID);
        this.assertError();
    }
}

