/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.session.AbstractLoginTest;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.java.Charsets;
import com.openexchange.test.json.JSONAssertion;
import com.openexchange.tools.encoding.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.junit.Test;

public class LoginTest
extends AbstractLoginTest {
    public LoginTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.createClient();
    }

    protected void tearDown() {
    }

    public void testSuccessfulLoginReturnsSession() throws Exception {
        this.assertResponseContains("session");
    }

    public void testSuccessfulLoginLacksRandom() throws Exception {
        this.assertResponseLacks("random");
    }

    public void testSuccessfulLoginSetsSecretCookie() throws Exception {
        this.rawLogin("login");
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        boolean found = false;
        ArrayList<String> cookieNames = new ArrayList<String>(cookies.length);
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            cookieNames.add(name);
            found = found || name.startsWith("open-xchange-secret");
        }
        LoginTest.assertTrue((String)("Missing secret cookie: " + ((Object)cookieNames).toString()), (boolean)found);
    }

    public void testSuccessfulLoginDoesNotSetSessionCookie() throws Exception {
        this.rawLogin("login");
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        boolean found = false;
        ArrayList<String> cookieNames = new ArrayList<String>(cookies.length);
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            cookieNames.add(name);
            found = found || name.startsWith("open-xchange-session");
        }
        LoginTest.assertFalse((String)("Found session cookie, but shouldn't have: " + ((Object)cookieNames).toString()), (boolean)found);
    }

    public void testSecretCookiesDifferPerClientID() throws Exception {
        String[] credentials = this.credentials("login");
        this.inModule("login");
        this.raw("login", "name", credentials[0], "password", credentials[1], "client", "testclient1");
        this.raw("login", "name", credentials[0], "password", credentials[1], "client", "testclient2");
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        int counter = 0;
        ArrayList<String> cookieNames = new ArrayList<String>(cookies.length);
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            cookieNames.add(name);
            if (!name.startsWith("open-xchange-secret")) continue;
            ++counter;
        }
        LoginTest.assertTrue((String)("Missing secret cookie: " + ((Object)cookieNames).toString()), (counter == 2 ? 1 : 0) != 0);
    }

    public void testSecretCookieLifetimeIsLongerThanADay() throws Exception {
        this.rawLogin("login");
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        ArrayList<String> cookieNames = new ArrayList<String>(cookies.length);
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            cookieNames.add(name);
            if (!name.startsWith("open-xchange-secret")) continue;
            LoginTest.assertNotNull((Object)cookie.getExpiryDate());
            Date tomorrow = TimeTools.D("tomorrow");
            LoginTest.assertTrue((boolean)cookie.getExpiryDate().after(tomorrow));
        }
    }

    public void testSuccessfulLoginAllowsSubsequentRequests() throws Exception {
        this.as("login");
        this.inModule("quota");
        this.call("filestore", new Object[0]);
        this.assertNoError();
    }

    public void testRefreshSecretActionResetsSecretCookieLifetime() throws Exception {
        int i;
        this.rawLogin("login");
        Date oldCookie = null;
        Date newCookie = null;
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        for (i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().startsWith("open-xchange-secret")) continue;
            oldCookie = cookies[i].getExpiryDate();
        }
        Thread.sleep(1000L);
        this.raw("refreshSecret", "session", this.rawResponse.getString("session"));
        cookies = this.currentClient.getClient().getState().getCookies();
        for (i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().startsWith("open-xchange-secret")) continue;
            newCookie = cookies[i].getExpiryDate();
        }
        LoginTest.assertNotNull((String)"Precondition: Should find secret cookie after renewal", newCookie);
        LoginTest.assertNotNull((String)"Precondition: Should find secret cookie first", (Object)oldCookie);
        LoginTest.assertTrue((String)"Refreshed secret cookie should have newer expiry date", (newCookie.compareTo(oldCookie) > 0 ? 1 : 0) != 0);
    }

    public void testWrongCredentials() throws Exception {
        this.inModule("login");
        this.call("login", "name", "foo", "password", "bar");
        this.assertError();
    }

    public void testNonExistingSessionIDOnSubsequentRequests() throws Exception {
        this.as("login");
        this.inModule("quota");
        this.call("filestore", "session", "1234567");
        this.assertError();
    }

    public void testSessionIDAndSecretMismatch() throws Exception {
        this.as("login");
        String sessionID = this.currentClient.getSessionID();
        this.as("seconduser");
        this.inModule("quota");
        this.call("filestore", "session", sessionID);
        this.assertError();
    }

    public void testSessionRandomMissingAndUnusable() throws Exception {
        this.rawLogin("login");
        if (!this.rawResponse.has("random")) {
            String sessionID = this.rawResponse.getString("session");
            this.callGeneral("logintest", "randomtoken", "session", sessionID);
            this.assertNoError();
            Map<String, Object> details = this.details();
            Object randomObject = details.get("random");
            LoginTest.assertNotNull((Object)randomObject);
            HttpMethod redirectMethod = this.rawMethod("login", "redirect", "session", sessionID, "random", randomObject);
            LoginTest.assertEquals((String)"action=redirect shouldn't work when randomToken is disabled", (int)400, (int)redirectMethod.getStatusCode());
            HttpMethod redeemMethod = this.rawMethod("login", "redeem", "session", sessionID, "random", randomObject);
            LoginTest.assertEquals((String)"action=redeem shouldn't work when randomToken is disabled", (int)400, (int)redeemMethod.getStatusCode());
        }
    }

    @Test
    public void testCookieHashSalt() throws Exception {
        Cookie[] cookies;
        this.rawLogin("login");
        HttpClient client = this.currentClient.getClient();
        String agent = (String)client.getParams().getParameter("http.useragent");
        String salt = "replaceMe1234567890";
        for (Cookie cookie : cookies = client.getState().getCookies()) {
            if (cookie.getName().startsWith("open-xchange-secret")) {
                LoginTest.assertEquals((String)"Bad cookie hash.", (String)("open-xchange-secret-" + this.getHash(agent, salt)), (String)cookie.getName());
                continue;
            }
            if (!cookie.getName().startsWith("open-xchange-session")) continue;
            LoginTest.assertEquals((String)"Bad cookie hash.", (String)("open-xchange-session-" + this.getHash(agent, salt)), (String)cookie.getName());
        }
    }

    private void assertResponseContains(String key) throws Exception {
        this.rawLogin("login");
        this.assertRaw(new JSONAssertion().isObject().hasKey(key));
    }

    private void assertResponseLacks(String key) throws Exception {
        this.rawLogin("login");
        this.assertRaw(new JSONAssertion().isObject().lacksKey(key));
    }

    private void rawLogin(String user) throws Exception {
        String[] credentials = this.credentials(user);
        this.inModule("login");
        this.raw("login", "name", credentials[0], "password", credentials[1]);
    }

    private String getHash(String agent, String salt) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(agent.getBytes(Charsets.UTF_8));
        md.update("com.openexchange.ox.gui.dhtml".getBytes(Charsets.UTF_8));
        md.update(salt.getBytes());
        return Pattern.compile("\\W").matcher(Base64.encode((byte[])md.digest())).replaceAll("");
    }
}

