/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.session.actions.HttpAuthRequest;
import com.openexchange.ajax.session.actions.HttpAuthResponse;
import com.openexchange.configuration.AJAXConfig;
import junit.framework.TestCase;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpAuthTest
extends TestCase {
    private String protocol;
    private String hostname;
    private String login;
    private String password;

    public HttpAuthTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        AJAXConfig.init();
        this.protocol = AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL);
        this.hostname = AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME);
        this.login = AJAXConfig.getProperty(AJAXConfig.Property.LOGIN) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password = AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD);
    }

    protected void tearDown() throws Exception {
        this.login = null;
        this.password = null;
        super.tearDown();
    }

    public void testAuthorizationRequired() throws Throwable {
        DefaultHttpClient client2 = AJAXSession.newHttpClient();
        HttpGet request = new HttpGet(this.protocol + "://" + this.hostname + "/ajax/login/httpAuth");
        HttpResponse response = client2.execute((HttpUriRequest)request);
        HttpAuthTest.assertEquals((String)"HTTP auth URL does not respond with a required authorization.", (int)401, (int)response.getStatusLine().getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirect() throws Throwable {
        AJAXSession session = new AJAXSession();
        AJAXClient myClient = new AJAXClient(session, false);
        try {
            session.getHttpClient().getParams().setBooleanParameter("http.protocol.handle-redirects", false);
            HttpAuthResponse response = myClient.execute(new HttpAuthRequest(this.login, this.password));
            String location = response.getLocation();
            HttpAuthTest.assertNotNull((String)"Location is missing in response.", (Object)location);
            int sessionStart = location.indexOf("session=");
            String sessionId = location.substring(sessionStart + 8, location.indexOf(38, sessionStart + 8));
            session.setId(sessionId);
        }
        finally {
            myClient.logout();
        }
    }
}

