/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public abstract class AJAXTest {
    public static final String PROTOCOL = "http://";
    private static final String MAILFILTER_URL = "/ajax/mailfilter";
    private static final String LOGOUT_URL = "/ajax/login";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterconfigTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            this.mailfilterconfig(login, this.getHostname(), this.getUsername());
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterlistTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            this.mailfilterlist(login, this.getHostname(), this.getUsername());
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterdeleteTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}", null);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"position\":0,\"flags\":[],\"actioncmds\":[{\"into\":\"default.INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"position\":0,\"flags\":[],\"actioncmds\":[{\"into\":\"default.INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterVacationTestWithOutSubject() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            JSONObject base = new JSONObject();
            base.put("rulename", (Object)"Abwesenheitsbenachrichtigung");
            base.put("active", (Object)Boolean.TRUE);
            base.append("flags", (Object)"vacation");
            JSONObject test = new JSONObject();
            test.put("id", (Object)"true");
            base.put("test", (Object)test);
            JSONObject action = new JSONObject();
            action.put("id", (Object)"vacation");
            action.put("days", 7);
            action.append("addresses", (Object)"dennis.sieben@open-xchange.com");
            action.put("text", (Object)"I'm out of office");
            base.append("actioncmds", (Object)action);
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), base.toString(), null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationPlainAtTheEndTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"text\":\"if true \\r\\n{\\r\\n    vacation :days 13 :addresses [ \\\"root@localhost\\\" , \\\"billg@microsoft.com\\\" ] :mime :subject \\\"Betreff\\\" \\\"Text\\r\\nText\\\" ;\\r\\n}\\r\\n\",\"errormsg\":\"\",\"flags\":[\"vacation\"],\"id\":3,\"rulename\":\"Vacation Notice\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"text\":\"if true \\r\\n{\\r\\n    vacation :days 13 :addresses [ \\\"root@localhost\\\" , \\\"billg@microsoft.com\\\" ] :mime :subject \\\"Betreff\\\" \\\"Text\\r\\nText\\\" ;\\r\\n}\\r\\n\",\"errormsg\":\"\",\"flags\":[\"vacation\"],\"id\":3,\"rulename\":\"Vacation Notice\"}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationPlainInBetweenTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"position\":0,\"text\":\"if true \\r\\n{\\r\\n    vacation :days 13 :addresses [ \\\"root@localhost\\\" , \\\"billg@microsoft.com\\\" ] :mime :subject \\\"Betreff\\\" \\\"Text\\r\\nText\\\" ;\\r\\n}\\r\\n\",\"errormsg\":\"\",\"flags\":[\"vacation\"],\"id\":3,\"rulename\":\"Vacation Notice\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"position\":0,\"text\":\"if true \\r\\n{\\r\\n    vacation :days 13 :addresses [ \\\"root@localhost\\\" , \\\"billg@microsoft.com\\\" ] :mime :subject \\\"Betreff\\\" \\\"Text\\r\\nText\\\" ;\\r\\n}\\r\\n\",\"errormsg\":\"\",\"flags\":[\"vacation\"],\"id\":3,\"rulename\":\"Vacation Notice\"}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"Vacation Notice\",\"active\":true,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":13,\"addresses\":[\"root@localhost\",\"billg@microsoft.com\"],\"subject\":\"Betreff\",\"text\":\"Text\\u000aText\"}]}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"Vacation Notice\",\"active\":true,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":13,\"addresses\":[\"root@localhost\",\"billg@microsoft.com\"],\"subject\":\"Betreff\",\"text\":\"Text\\u000aText\"}]}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacation2Test() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"Vacation Notice\",\"active\":true,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":13,\"addresses\":[\"root@localhost\",\"billg@microsoft.com\"],\"subject\":\"Betreff\",\"text\":\"Text\\u000aText\"}],\"id\":5}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"Vacation Notice\",\"active\":true,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":13,\"addresses\":[\"root@localhost\",\"billg@microsoft.com\"],\"subject\":\"Betreff\",\"text\":\"Text\\u000aText\"}],\"id\":5}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacation3Test() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"New x\",\"test\":{\"id\":\"header\",\"comparison\":\"contains\",\"values\":[\"\"],\"headers\":[\"X-Been-There\",\"X-Mailinglist\"]},\"actioncmds\":[{\"id\":\"redirect\",\"to\":\"xyz@bla.de\"}],\"flags\":[],\"active\":true}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"New x\",\"test\":{\"id\":\"header\",\"comparison\":\"contains\",\"values\":[\"\"],\"headers\":[\"X-Been-There\",\"X-Mailinglist\"]},\"actioncmds\":[{\"id\":\"redirect\",\"to\":\"xyz@bla.de\"}],\"flags\":[],\"active\":true}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationDeactiveAtTheEndTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"Vacation Notice\",\"active\":false,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":1,\"addresses\":[\"dsfa\"],\"subject\":\"123\",\"text\":\"123\"}]}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"Vacation Notice\",\"active\":false,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":1,\"addresses\":[\"dsfa\"],\"subject\":\"123\",\"text\":\"123\"}]}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationDeactiveInBetweenTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"Vacation Notice\",\"position\":0,\"active\":false,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":1,\"addresses\":[\"dsfa\"],\"subject\":\"123\",\"text\":\"123\"}]}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"Vacation Notice\",\"position\":0,\"active\":false,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":1,\"addresses\":[\"dsfa\"],\"subject\":\"123\",\"text\":\"123\"}]}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewSizeTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"sizerule\",\"test\":{\"id\":\"size\",\"comparison\":\"over\",\"size\":88},\"actioncmds\":[{\"id\":\"keep\"}],\"flags\":[],\"active\":true}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"sizerule\",\"test\":{\"id\":\"size\",\"comparison\":\"over\",\"size\":88},\"actioncmds\":[{\"id\":\"keep\"}],\"flags\":[],\"active\":true}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewCurrentDateTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            JSONObject base = new JSONObject();
            base.put("rulename", (Object)"sizerule");
            base.put("active", (Object)Boolean.TRUE);
            base.append("flags", (Object)"vacation");
            JSONObject test = new JSONObject();
            test.put("id", (Object)"allof");
            test.append("tests", (Object)this.currentdate(1183759200000L, "ge"));
            test.append("tests", (Object)this.currentdate(1183759200000L, "le"));
            test.append("tests", (Object)this.currentdate(1183759200000L, "is"));
            base.put("test", (Object)test);
            JSONObject action = new JSONObject();
            action.put("id", (Object)"vacation");
            action.put("days", 7);
            action.append("addresses", (Object)"dennis.sieben@open-xchange.com");
            action.put("text", (Object)"I'm out of office");
            base.append("actioncmds", (Object)action);
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), base.toString(), null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    private JSONObject currentdate(long date, String comparison) throws JSONException {
        JSONObject currentdate2 = new JSONObject();
        currentdate2.put("id", (Object)"currentdate");
        currentdate2.put("comparison", (Object)comparison);
        currentdate2.append("datevalue", (Object)date);
        currentdate2.put("datepart", (Object)"date");
        return currentdate2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewTestMissingHeaders() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"position\":0,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"position\":0,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}", "headers");
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewTestWithoutPosition() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}", null);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterreorderTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "[5,7,8]";
            this.mailfilterreorder(login, this.getHostname(), this.getUsername(), "[5,7,8]");
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterupdateTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"position\":0,\"flags\":[],\"id\":7,\"rulename\":\"testrule\"}";
            this.mailfilterupdate(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"position\":0,\"flags\":[],\"id\":7,\"rulename\":\"testrule\"}");
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterupdateTest2() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":false,\"position\":0,\"flags\":[],\"id\":7,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            this.mailfilterupdate(login, this.getHostname(), this.getUsername(), "{\"active\":false,\"position\":0,\"flags\":[],\"id\":7,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}");
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfiltergetScriptTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            this.mailfiltergetScript(login, this.getHostname(), this.getUsername());
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterdeleteScriptTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            this.mailfilterdeleteScript(login, this.getHostname(), this.getUsername());
        }
        finally {
            this.logout(login);
        }
    }

    protected abstract String getHostname();

    protected abstract String getUsername();

    protected abstract WebconversationAndSessionID login() throws MalformedURLException, IOException, SAXException, JSONException;

    private void logout(WebconversationAndSessionID conversation) throws MalformedURLException, IOException, SAXException, JSONException {
        GetMethodWebRequest req = new GetMethodWebRequest(PROTOCOL + this.getHostname() + LOGOUT_URL);
        req.setParameter("action", "logout");
        req.setParameter("session", conversation.getSessionid());
        WebResponse resp = conversation.getWebConversation().getResponse((WebRequest)req);
        junit.framework.Assert.assertEquals((int)200, (int)resp.getResponseCode());
    }

    private void setSessionParameter(WebconversationAndSessionID conversation, WebRequest reqmailfilter) {
        reqmailfilter.setParameter("session", conversation.getSessionid());
    }

    private void mailfilterdelete(WebconversationAndSessionID conversation, String hostname, String username, int number) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject object = new JSONObject();
        object.put("id", number);
        byte[] bytes = object.toString().getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest reqmailfilter = null != username ? new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=delete&session=" + conversation.getSessionid() + "&username=" + username, (InputStream)bais, "text/javascript; charset=UTF-8") : new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=delete&session=" + conversation.getSessionid(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        junit.framework.Assert.assertEquals((int)200, (int)mailfilterresp.getResponseCode());
    }

    private void mailfilterlist(WebconversationAndSessionID conversation, String hostname, String username) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        GetMethodWebRequest reqmailfilter = new GetMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL);
        reqmailfilter.setParameter("action", "list");
        if (null != username) {
            reqmailfilter.setParameter("username", username);
        }
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.optJSONArray("error_params")), (boolean)json.has("error"));
        System.out.println("Rules:");
        System.out.println("------");
        JSONArray testJsonArray = json.getJSONArray("data");
        for (int i = 0; i < testJsonArray.length(); ++i) {
            System.out.println(testJsonArray.getJSONObject(i));
            System.out.println("Test: " + testJsonArray.getJSONObject(i).getJSONObject("test"));
            System.out.println("--------------");
        }
    }

    private void mailfilterconfig(WebconversationAndSessionID conversation, String hostname, String username) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        GetMethodWebRequest reqmailfilter = new GetMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL);
        reqmailfilter.setParameter("action", "config");
        if (null != username) {
            reqmailfilter.setParameter("username", username);
        }
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println("Tests:");
        System.out.println("------");
        JSONArray testJsonArray = json.getJSONObject("data").getJSONArray("tests");
        for (int i = 0; i < testJsonArray.length(); ++i) {
            System.out.println(testJsonArray.getJSONObject(i));
        }
        System.out.println("Actioncommands:" + json.getJSONObject("data").getJSONArray("actioncommands"));
    }

    private String mailfilternew(WebconversationAndSessionID conversation, String hostname, String username, String jsonString, String errorfound) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        byte[] bytes = jsonString.getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest reqmailfilter = null != username ? new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=new&username=" + username + "&session=" + conversation.getSessionid(), (InputStream)bais, "text/javascript; charset=UTF-8") : new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=new&session=" + conversation.getSessionid(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        if (null != errorfound) {
            Assert.assertTrue((String)"No error params", (boolean)json.has("error_params"));
            Assert.assertTrue((String)("The given error string: " + errorfound + " was not found in the error params"), (boolean)json.optString("error_params").contains(errorfound));
            return null;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        return json.getString("data");
    }

    private void mailfilterreorder(WebconversationAndSessionID conversation, String hostname, String username, String jsonArray) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        byte[] bytes = jsonArray.getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest reqmailfilter = null != username ? new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=new&username=" + username, (InputStream)bais, "text/javascript; charset=UTF-8") : new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=reorder", (InputStream)bais, "text/javascript; charset=UTF-8");
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println(json);
    }

    private void mailfilterupdate(WebconversationAndSessionID conversation, String hostname, String username, String test) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        byte[] bytes = test.getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest reqmailfilter = null != username ? new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=update&username=" + username, (InputStream)bais, "text/javascript; charset=UTF-8") : new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=update", (InputStream)bais, "text/javascript; charset=UTF-8");
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println(json);
    }

    private void mailfiltergetScript(WebconversationAndSessionID conversation, String hostname, String username) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        GetMethodWebRequest reqmailfilter = new GetMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL);
        reqmailfilter.setParameter("action", "getscript");
        if (null != username) {
            reqmailfilter.setParameter("username", username);
        }
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println(json);
    }

    private void mailfilterdeleteScript(WebconversationAndSessionID conversation, String hostname, String username) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        GetMethodWebRequest reqmailfilter = new GetMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL);
        reqmailfilter.setParameter("action", "deletescript");
        if (null != username) {
            reqmailfilter.setParameter("username", username);
        }
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println(json);
    }

    public class WebconversationAndSessionID {
        private final WebConversation webConversation;
        private final String sessionid;

        public WebconversationAndSessionID(WebConversation webConversation, String sessionid) {
            this.sessionid = sessionid;
            this.webConversation = webConversation;
        }

        public final WebConversation getWebConversation() {
            return this.webConversation;
        }

        public final String getSessionid() {
            return this.sessionid;
        }
    }
}

